/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.Deployment;
import com.azure.ai.projects.models.DeploymentType;
import com.azure.ai.projects.models.Sku;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ModelDeployment
extends Deployment {
    private DeploymentType type = DeploymentType.MODEL_DEPLOYMENT;
    private String modelName;
    private String modelVersion;
    private String modelPublisher;
    private Map<String, String> capabilities;
    private Sku sku;
    private String connectionName;

    private ModelDeployment() {
    }

    @Override
    public DeploymentType getType() {
        return this.type;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelPublisher() {
        return this.modelPublisher;
    }

    public Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    public Sku getSku() {
        return this.sku;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ModelDeployment fromJson(JsonReader jsonReader) throws IOException {
        return (ModelDeployment)jsonReader.readObject(reader -> {
            ModelDeployment deserializedModelDeployment = new ModelDeployment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedModelDeployment.setName(reader.getString());
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    deserializedModelDeployment.modelName = reader.getString();
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedModelDeployment.modelVersion = reader.getString();
                    continue;
                }
                if ("modelPublisher".equals(fieldName)) {
                    deserializedModelDeployment.modelPublisher = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    Map capabilities;
                    deserializedModelDeployment.capabilities = capabilities = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedModelDeployment.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedModelDeployment.type = DeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    deserializedModelDeployment.connectionName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModelDeployment;
        });
    }
}

