/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.InputData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class InputDataset
extends InputData {
    private String type = "dataset";
    private final String id;

    public InputDataset(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static InputDataset fromJson(JsonReader jsonReader) throws IOException {
        return (InputDataset)jsonReader.readObject(reader -> {
            String id = null;
            String type = "dataset";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            InputDataset deserializedInputDataset = new InputDataset(id);
            deserializedInputDataset.type = type;
            return deserializedInputDataset;
        });
    }
}

