/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.AzureAISearchIndex;
import com.azure.ai.projects.models.CosmosDBIndex;
import com.azure.ai.projects.models.IndexType;
import com.azure.ai.projects.models.ManagedAzureAISearchIndex;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Index
implements JsonSerializable<Index> {
    private IndexType type = IndexType.fromString("Index");
    private String id;
    private String name;
    private String version;
    private String description;
    private Map<String, String> tags;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public IndexType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Index setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Index setTags(Map<String, String> tags) {
        this.tags = tags;
        this.updatedProperties.add("tags");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.tags == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.tags, (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Index fromJson(JsonReader jsonReader) throws IOException {
        return (Index)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Index index;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureSearch".equals(discriminatorValue)) {
                    index = AzureAISearchIndex.fromJson(readerToUse.reset());
                    return index;
                }
                if ("ManagedAzureSearch".equals(discriminatorValue)) {
                    index = ManagedAzureAISearchIndex.fromJson(readerToUse.reset());
                    return index;
                }
                if ("CosmosDBNoSqlVectorStore".equals(discriminatorValue)) {
                    index = CosmosDBIndex.fromJson(readerToUse.reset());
                    return index;
                }
                index = Index.fromJsonKnownDiscriminator(readerToUse.reset());
                return index;
            }
        });
    }

    static Index fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Index)jsonReader.readObject(reader -> {
            Index deserializedIndex = new Index();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIndex.name = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedIndex.version = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIndex.type = IndexType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedIndex.id = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIndex.description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedIndex.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIndex;
        });
    }

    static {
        JsonMergePatchHelper.setIndexAccessor(new JsonMergePatchHelper.IndexAccessor(){

            @Override
            public Index prepareModelForJsonMergePatch(Index model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(Index model) {
                return model.jsonMergePatch;
            }

            @Override
            public void setId(Index model, String id) {
                model.id = id;
            }

            @Override
            public void setName(Index model, String name) {
                model.name = name;
            }

            @Override
            public void setVersion(Index model, String version) {
                model.version = version;
            }

            @Override
            public void setDescription(Index model, String description) {
                model.description = description;
            }

            @Override
            public void setTags(Index model, Map<String, String> tags) {
                model.tags = tags;
            }
        });
    }
}

