/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FieldMapping
implements JsonSerializable<FieldMapping> {
    private List<String> contentFields;
    private String filepathField;
    private String titleField;
    private String urlField;
    private List<String> vectorFields;
    private List<String> metadataFields;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public List<String> getContentFields() {
        return this.contentFields;
    }

    public FieldMapping setContentFields(List<String> contentFields) {
        this.contentFields = contentFields;
        this.updatedProperties.add("contentFields");
        return this;
    }

    public String getFilepathField() {
        return this.filepathField;
    }

    public FieldMapping setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        this.updatedProperties.add("filepathField");
        return this;
    }

    public String getTitleField() {
        return this.titleField;
    }

    public FieldMapping setTitleField(String titleField) {
        this.titleField = titleField;
        this.updatedProperties.add("titleField");
        return this;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public FieldMapping setUrlField(String urlField) {
        this.urlField = urlField;
        this.updatedProperties.add("urlField");
        return this;
    }

    public List<String> getVectorFields() {
        return this.vectorFields;
    }

    public FieldMapping setVectorFields(List<String> vectorFields) {
        this.vectorFields = vectorFields;
        this.updatedProperties.add("vectorFields");
        return this;
    }

    public List<String> getMetadataFields() {
        return this.metadataFields;
    }

    public FieldMapping setMetadataFields(List<String> metadataFields) {
        this.metadataFields = metadataFields;
        this.updatedProperties.add("metadataFields");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("contentFields", this.contentFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("filepathField", this.filepathField);
        jsonWriter.writeStringField("titleField", this.titleField);
        jsonWriter.writeStringField("urlField", this.urlField);
        jsonWriter.writeArrayField("vectorFields", this.vectorFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("metadataFields", this.metadataFields, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("contentFields")) {
            if (this.contentFields == null) {
                jsonWriter.writeNullField("contentFields");
            } else {
                jsonWriter.writeArrayField("contentFields", this.contentFields, (writer, element) -> writer.writeString(element));
            }
        }
        if (this.updatedProperties.contains("filepathField")) {
            if (this.filepathField == null) {
                jsonWriter.writeNullField("filepathField");
            } else {
                jsonWriter.writeStringField("filepathField", this.filepathField);
            }
        }
        if (this.updatedProperties.contains("titleField")) {
            if (this.titleField == null) {
                jsonWriter.writeNullField("titleField");
            } else {
                jsonWriter.writeStringField("titleField", this.titleField);
            }
        }
        if (this.updatedProperties.contains("urlField")) {
            if (this.urlField == null) {
                jsonWriter.writeNullField("urlField");
            } else {
                jsonWriter.writeStringField("urlField", this.urlField);
            }
        }
        if (this.updatedProperties.contains("vectorFields")) {
            if (this.vectorFields == null) {
                jsonWriter.writeNullField("vectorFields");
            } else {
                jsonWriter.writeArrayField("vectorFields", this.vectorFields, (writer, element) -> writer.writeString(element));
            }
        }
        if (this.updatedProperties.contains("metadataFields")) {
            if (this.metadataFields == null) {
                jsonWriter.writeNullField("metadataFields");
            } else {
                jsonWriter.writeArrayField("metadataFields", this.metadataFields, (writer, element) -> writer.writeString(element));
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FieldMapping fromJson(JsonReader jsonReader) throws IOException {
        return (FieldMapping)jsonReader.readObject(reader -> {
            FieldMapping deserializedFieldMapping = new FieldMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentFields".equals(fieldName)) {
                    List contentFields;
                    deserializedFieldMapping.contentFields = contentFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filepathField".equals(fieldName)) {
                    deserializedFieldMapping.filepathField = reader.getString();
                    continue;
                }
                if ("titleField".equals(fieldName)) {
                    deserializedFieldMapping.titleField = reader.getString();
                    continue;
                }
                if ("urlField".equals(fieldName)) {
                    deserializedFieldMapping.urlField = reader.getString();
                    continue;
                }
                if ("vectorFields".equals(fieldName)) {
                    List vectorFields;
                    deserializedFieldMapping.vectorFields = vectorFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("metadataFields".equals(fieldName)) {
                    List metadataFields;
                    deserializedFieldMapping.metadataFields = metadataFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFieldMapping;
        });
    }

    static {
        JsonMergePatchHelper.setFieldMappingAccessor(new JsonMergePatchHelper.FieldMappingAccessor(){

            @Override
            public FieldMapping prepareModelForJsonMergePatch(FieldMapping model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(FieldMapping model) {
                return model.jsonMergePatch;
            }
        });
    }
}

