/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.EvaluatorConfiguration;
import com.azure.ai.projects.models.InputData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class Evaluation
implements JsonSerializable<Evaluation> {
    private String name;
    private final InputData data;
    private String displayName;
    private String description;
    private String status;
    private Map<String, String> tags;
    private Map<String, String> properties;
    private final Map<String, EvaluatorConfiguration> evaluators;

    public Evaluation(InputData data, Map<String, EvaluatorConfiguration> evaluators) {
        this.data = data;
        this.evaluators = evaluators;
    }

    public String getName() {
        return this.name;
    }

    public InputData getData() {
        return this.data;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Evaluation setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Evaluation setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Evaluation setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Evaluation setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, EvaluatorConfiguration> getEvaluators() {
        return this.evaluators;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("data", (JsonSerializable)this.data);
        jsonWriter.writeMapField("evaluators", this.evaluators, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Evaluation fromJson(JsonReader jsonReader) throws IOException {
        return (Evaluation)jsonReader.readObject(reader -> {
            String name = null;
            InputData data = null;
            Map evaluators = null;
            String displayName = null;
            String description = null;
            String status = null;
            Map tags = null;
            Map properties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    data = InputData.fromJson(reader);
                    continue;
                }
                if ("evaluators".equals(fieldName)) {
                    evaluators = reader.readMap(reader1 -> EvaluatorConfiguration.fromJson(reader1));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            Evaluation deserializedEvaluation = new Evaluation(data, evaluators);
            deserializedEvaluation.name = name;
            deserializedEvaluation.displayName = displayName;
            deserializedEvaluation.description = description;
            deserializedEvaluation.status = status;
            deserializedEvaluation.tags = tags;
            deserializedEvaluation.properties = properties;
            return deserializedEvaluation;
        });
    }
}

