/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class EmbeddingConfiguration
implements JsonSerializable<EmbeddingConfiguration> {
    private String modelDeploymentName;
    private String embeddingField;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getModelDeploymentName() {
        return this.modelDeploymentName;
    }

    public EmbeddingConfiguration setModelDeploymentName(String modelDeploymentName) {
        this.modelDeploymentName = modelDeploymentName;
        this.updatedProperties.add("modelDeploymentName");
        return this;
    }

    public String getEmbeddingField() {
        return this.embeddingField;
    }

    public EmbeddingConfiguration setEmbeddingField(String embeddingField) {
        this.embeddingField = embeddingField;
        this.updatedProperties.add("embeddingField");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelDeploymentName", this.modelDeploymentName);
        jsonWriter.writeStringField("embeddingField", this.embeddingField);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("modelDeploymentName")) {
            if (this.modelDeploymentName == null) {
                jsonWriter.writeNullField("modelDeploymentName");
            } else {
                jsonWriter.writeStringField("modelDeploymentName", this.modelDeploymentName);
            }
        }
        if (this.updatedProperties.contains("embeddingField")) {
            if (this.embeddingField == null) {
                jsonWriter.writeNullField("embeddingField");
            } else {
                jsonWriter.writeStringField("embeddingField", this.embeddingField);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingConfiguration)jsonReader.readObject(reader -> {
            EmbeddingConfiguration deserializedEmbeddingConfiguration = new EmbeddingConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelDeploymentName".equals(fieldName)) {
                    deserializedEmbeddingConfiguration.modelDeploymentName = reader.getString();
                    continue;
                }
                if ("embeddingField".equals(fieldName)) {
                    deserializedEmbeddingConfiguration.embeddingField = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEmbeddingConfiguration;
        });
    }

    static {
        JsonMergePatchHelper.setEmbeddingConfigurationAccessor(new JsonMergePatchHelper.EmbeddingConfigurationAccessor(){

            @Override
            public EmbeddingConfiguration prepareModelForJsonMergePatch(EmbeddingConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(EmbeddingConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

