/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.DeploymentType;
import com.azure.ai.projects.models.ModelDeployment;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class Deployment
implements JsonSerializable<Deployment> {
    private DeploymentType type = DeploymentType.fromString("Deployment");
    private String name;

    protected Deployment() {
    }

    public DeploymentType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    Deployment setName(String name) {
        this.name = name;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Deployment fromJson(JsonReader jsonReader) throws IOException {
        return (Deployment)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Deployment deployment;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ModelDeployment".equals(discriminatorValue)) {
                    deployment = ModelDeployment.fromJson(readerToUse.reset());
                    return deployment;
                }
                deployment = Deployment.fromJsonKnownDiscriminator(readerToUse.reset());
                return deployment;
            }
        });
    }

    static Deployment fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Deployment)jsonReader.readObject(reader -> {
            Deployment deserializedDeployment = new Deployment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDeployment.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeployment.type = DeploymentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeployment;
        });
    }
}

