/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.DatasetType;
import com.azure.ai.projects.models.FileDatasetVersion;
import com.azure.ai.projects.models.FolderDatasetVersion;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatasetVersion
implements JsonSerializable<DatasetVersion> {
    private DatasetType type = DatasetType.fromString("DatasetVersion");
    private String dataUri;
    private Boolean isReference;
    private String id;
    private String name;
    private String version;
    private String description;
    private Map<String, String> tags;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;
    private String connectionName;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public DatasetType getType() {
        return this.type;
    }

    public String getDataUri() {
        return this.dataUri;
    }

    public DatasetVersion setDataUri(String dataUri) {
        this.dataUri = dataUri;
        this.updatedProperties.add("dataUri");
        return this;
    }

    public Boolean isReference() {
        return this.isReference;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public DatasetVersion setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public DatasetVersion setTags(Map<String, String> tags) {
        this.tags = tags;
        this.updatedProperties.add("tags");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("dataUri", this.dataUri);
        jsonWriter.writeStringField("connectionName", this.connectionName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("dataUri")) {
            if (this.dataUri == null) {
                jsonWriter.writeNullField("dataUri");
            } else {
                jsonWriter.writeStringField("dataUri", this.dataUri);
            }
        }
        if (this.updatedProperties.contains("connectionName")) {
            if (this.connectionName == null) {
                jsonWriter.writeNullField("connectionName");
            } else {
                jsonWriter.writeStringField("connectionName", this.connectionName);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.tags == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.tags, (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DatasetVersion fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetVersion)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatasetVersion datasetVersion;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("uri_file".equals(discriminatorValue)) {
                    datasetVersion = FileDatasetVersion.fromJson(readerToUse.reset());
                    return datasetVersion;
                }
                if ("uri_folder".equals(discriminatorValue)) {
                    datasetVersion = FolderDatasetVersion.fromJson(readerToUse.reset());
                    return datasetVersion;
                }
                datasetVersion = DatasetVersion.fromJsonKnownDiscriminator(readerToUse.reset());
                return datasetVersion;
            }
        });
    }

    static DatasetVersion fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatasetVersion)jsonReader.readObject(reader -> {
            DatasetVersion deserializedDatasetVersion = new DatasetVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDatasetVersion.name = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDatasetVersion.version = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatasetVersion.type = DatasetType.fromString(reader.getString());
                    continue;
                }
                if ("dataUri".equals(fieldName)) {
                    deserializedDatasetVersion.dataUri = reader.getString();
                    continue;
                }
                if ("isReference".equals(fieldName)) {
                    deserializedDatasetVersion.isReference = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    deserializedDatasetVersion.connectionName = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDatasetVersion.id = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDatasetVersion.description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDatasetVersion.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasetVersion;
        });
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public DatasetVersion setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        this.updatedProperties.add("connectionName");
        return this;
    }

    static {
        JsonMergePatchHelper.setDatasetVersionAccessor(new JsonMergePatchHelper.DatasetVersionAccessor(){

            @Override
            public DatasetVersion prepareModelForJsonMergePatch(DatasetVersion model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(DatasetVersion model) {
                return model.jsonMergePatch;
            }

            @Override
            public void setDataUri(DatasetVersion model, String dataUri) {
                model.dataUri = dataUri;
            }

            @Override
            public void setIsReference(DatasetVersion model, Boolean isReference) {
                model.isReference = isReference;
            }

            @Override
            public void setConnectionName(DatasetVersion model, String connectionName) {
                model.connectionName = connectionName;
            }

            @Override
            public void setId(DatasetVersion model, String id) {
                model.id = id;
            }

            @Override
            public void setName(DatasetVersion model, String name) {
                model.name = name;
            }

            @Override
            public void setVersion(DatasetVersion model, String version) {
                model.version = version;
            }

            @Override
            public void setDescription(DatasetVersion model, String description) {
                model.description = description;
            }

            @Override
            public void setTags(DatasetVersion model, Map<String, String> tags) {
                model.tags = tags;
            }
        });
    }
}

