/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.BaseCredentials;
import com.azure.ai.projects.models.CredentialType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class CustomCredential
extends BaseCredentials {
    private CredentialType type = CredentialType.CUSTOM;
    private Map<String, String> keys;

    private CustomCredential() {
    }

    @Override
    public CredentialType getType() {
        return this.type;
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static CustomCredential fromJson(JsonReader jsonReader) throws IOException {
        return (CustomCredential)jsonReader.readObject(reader -> {
            CustomCredential deserializedCustomCredential = new CustomCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keys".equals(fieldName)) {
                    Map keys;
                    deserializedCustomCredential.keys = keys = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomCredential.type = CredentialType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomCredential;
        });
    }
}

