/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.SasCredential;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BlobReference
implements JsonSerializable<BlobReference> {
    private final String blobUri;
    private final String storageAccountArmId;
    private final SasCredential credential;

    private BlobReference(String blobUri, String storageAccountArmId, SasCredential credential) {
        this.blobUri = blobUri;
        this.storageAccountArmId = storageAccountArmId;
        this.credential = credential;
    }

    public String getBlobUri() {
        return this.blobUri;
    }

    public String getStorageAccountArmId() {
        return this.storageAccountArmId;
    }

    public SasCredential getCredential() {
        return this.credential;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobUri", this.blobUri);
        jsonWriter.writeStringField("storageAccountArmId", this.storageAccountArmId);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static BlobReference fromJson(JsonReader jsonReader) throws IOException {
        return (BlobReference)jsonReader.readObject(reader -> {
            String blobUri = null;
            String storageAccountArmId = null;
            SasCredential credential = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobUri".equals(fieldName)) {
                    blobUri = reader.getString();
                    continue;
                }
                if ("storageAccountArmId".equals(fieldName)) {
                    storageAccountArmId = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    credential = SasCredential.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new BlobReference(blobUri, storageAccountArmId, credential);
        });
    }
}

