/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.ApiKeyCredentials;
import com.azure.ai.projects.models.CredentialType;
import com.azure.ai.projects.models.CustomCredential;
import com.azure.ai.projects.models.EntraIDCredentials;
import com.azure.ai.projects.models.NoAuthenticationCredentials;
import com.azure.ai.projects.models.SasCredentials;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class BaseCredentials
implements JsonSerializable<BaseCredentials> {
    private CredentialType type = CredentialType.fromString("BaseCredentials");

    protected BaseCredentials() {
    }

    public CredentialType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static BaseCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (BaseCredentials)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BaseCredentials baseCredentials;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ApiKey".equals(discriminatorValue)) {
                    baseCredentials = ApiKeyCredentials.fromJson(readerToUse.reset());
                    return baseCredentials;
                }
                if ("AAD".equals(discriminatorValue)) {
                    baseCredentials = EntraIDCredentials.fromJson(readerToUse.reset());
                    return baseCredentials;
                }
                if ("CustomKeys".equals(discriminatorValue)) {
                    baseCredentials = CustomCredential.fromJson(readerToUse.reset());
                    return baseCredentials;
                }
                if ("SAS".equals(discriminatorValue)) {
                    baseCredentials = SasCredentials.fromJson(readerToUse.reset());
                    return baseCredentials;
                }
                if ("None".equals(discriminatorValue)) {
                    baseCredentials = NoAuthenticationCredentials.fromJson(readerToUse.reset());
                    return baseCredentials;
                }
                baseCredentials = BaseCredentials.fromJsonKnownDiscriminator(readerToUse.reset());
                return baseCredentials;
            }
        });
    }

    static BaseCredentials fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BaseCredentials)jsonReader.readObject(reader -> {
            BaseCredentials deserializedBaseCredentials = new BaseCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedBaseCredentials.type = CredentialType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseCredentials;
        });
    }
}

