/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.FieldMapping;
import com.azure.ai.projects.models.Index;
import com.azure.ai.projects.models.IndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class AzureAISearchIndex
extends Index {
    private IndexType type = IndexType.AZURE_SEARCH;
    private String connectionName;
    private String indexName;
    private FieldMapping fieldMapping;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public IndexType getType() {
        return this.type;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public AzureAISearchIndex setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        this.updatedProperties.add("connectionName");
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public AzureAISearchIndex setIndexName(String indexName) {
        this.indexName = indexName;
        this.updatedProperties.add("indexName");
        return this;
    }

    public FieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public AzureAISearchIndex setFieldMapping(FieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
        this.updatedProperties.add("fieldMapping");
        return this;
    }

    @Override
    public AzureAISearchIndex setDescription(String description) {
        super.setDescription(description);
        this.updatedProperties.add("description");
        return this;
    }

    @Override
    public AzureAISearchIndex setTags(Map<String, String> tags) {
        super.setTags(tags);
        this.updatedProperties.add("tags");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getIndexAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("connectionName", this.connectionName);
        jsonWriter.writeStringField("indexName", this.indexName);
        jsonWriter.writeJsonField("fieldMapping", (JsonSerializable)this.fieldMapping);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("description")) {
            if (this.getDescription() == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.getDescription());
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.getTags() == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("connectionName")) {
            if (this.connectionName == null) {
                jsonWriter.writeNullField("connectionName");
            } else {
                jsonWriter.writeStringField("connectionName", this.connectionName);
            }
        }
        if (this.updatedProperties.contains("indexName")) {
            if (this.indexName == null) {
                jsonWriter.writeNullField("indexName");
            } else {
                jsonWriter.writeStringField("indexName", this.indexName);
            }
        }
        if (this.updatedProperties.contains("fieldMapping")) {
            if (this.fieldMapping == null) {
                jsonWriter.writeNullField("fieldMapping");
            } else {
                JsonMergePatchHelper.getFieldMappingAccessor().prepareModelForJsonMergePatch(this.fieldMapping, true);
                jsonWriter.writeJsonField("fieldMapping", (JsonSerializable)this.fieldMapping);
                JsonMergePatchHelper.getFieldMappingAccessor().prepareModelForJsonMergePatch(this.fieldMapping, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureAISearchIndex fromJson(JsonReader jsonReader) throws IOException {
        return (AzureAISearchIndex)jsonReader.readObject(reader -> {
            AzureAISearchIndex deserializedAzureAISearchIndex = new AzureAISearchIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setName(deserializedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setVersion(deserializedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setId(deserializedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setDescription(deserializedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    JsonMergePatchHelper.getIndexAccessor().setTags(deserializedAzureAISearchIndex, tags);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureAISearchIndex.type = IndexType.fromString(reader.getString());
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    deserializedAzureAISearchIndex.connectionName = reader.getString();
                    continue;
                }
                if ("indexName".equals(fieldName)) {
                    deserializedAzureAISearchIndex.indexName = reader.getString();
                    continue;
                }
                if ("fieldMapping".equals(fieldName)) {
                    deserializedAzureAISearchIndex.fieldMapping = FieldMapping.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureAISearchIndex;
        });
    }
}

