/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.AgentEvaluationRedactionConfiguration;
import com.azure.ai.projects.models.AgentEvaluationSamplingConfiguration;
import com.azure.ai.projects.models.EvaluatorConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class AgentEvaluationRequest
implements JsonSerializable<AgentEvaluationRequest> {
    private final String runId;
    private String threadId;
    private final Map<String, EvaluatorConfiguration> evaluators;
    private AgentEvaluationSamplingConfiguration samplingConfiguration;
    private AgentEvaluationRedactionConfiguration redactionConfiguration;
    private final String appInsightsConnectionString;

    public AgentEvaluationRequest(String runId, Map<String, EvaluatorConfiguration> evaluators, String appInsightsConnectionString) {
        this.runId = runId;
        this.evaluators = evaluators;
        this.appInsightsConnectionString = appInsightsConnectionString;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public AgentEvaluationRequest setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public Map<String, EvaluatorConfiguration> getEvaluators() {
        return this.evaluators;
    }

    public AgentEvaluationSamplingConfiguration getSamplingConfiguration() {
        return this.samplingConfiguration;
    }

    public AgentEvaluationRequest setSamplingConfiguration(AgentEvaluationSamplingConfiguration samplingConfiguration) {
        this.samplingConfiguration = samplingConfiguration;
        return this;
    }

    public AgentEvaluationRedactionConfiguration getRedactionConfiguration() {
        return this.redactionConfiguration;
    }

    public AgentEvaluationRequest setRedactionConfiguration(AgentEvaluationRedactionConfiguration redactionConfiguration) {
        this.redactionConfiguration = redactionConfiguration;
        return this;
    }

    public String getAppInsightsConnectionString() {
        return this.appInsightsConnectionString;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("runId", this.runId);
        jsonWriter.writeMapField("evaluators", this.evaluators, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("appInsightsConnectionString", this.appInsightsConnectionString);
        jsonWriter.writeStringField("threadId", this.threadId);
        jsonWriter.writeJsonField("samplingConfiguration", (JsonSerializable)this.samplingConfiguration);
        jsonWriter.writeJsonField("redactionConfiguration", (JsonSerializable)this.redactionConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static AgentEvaluationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AgentEvaluationRequest)jsonReader.readObject(reader -> {
            String runId = null;
            Map evaluators = null;
            String appInsightsConnectionString = null;
            String threadId = null;
            AgentEvaluationSamplingConfiguration samplingConfiguration = null;
            AgentEvaluationRedactionConfiguration redactionConfiguration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runId".equals(fieldName)) {
                    runId = reader.getString();
                    continue;
                }
                if ("evaluators".equals(fieldName)) {
                    evaluators = reader.readMap(reader1 -> EvaluatorConfiguration.fromJson(reader1));
                    continue;
                }
                if ("appInsightsConnectionString".equals(fieldName)) {
                    appInsightsConnectionString = reader.getString();
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    threadId = reader.getString();
                    continue;
                }
                if ("samplingConfiguration".equals(fieldName)) {
                    samplingConfiguration = AgentEvaluationSamplingConfiguration.fromJson(reader);
                    continue;
                }
                if ("redactionConfiguration".equals(fieldName)) {
                    redactionConfiguration = AgentEvaluationRedactionConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AgentEvaluationRequest deserializedAgentEvaluationRequest = new AgentEvaluationRequest(runId, evaluators, appInsightsConnectionString);
            deserializedAgentEvaluationRequest.threadId = threadId;
            deserializedAgentEvaluationRequest.samplingConfiguration = samplingConfiguration;
            deserializedAgentEvaluationRequest.redactionConfiguration = redactionConfiguration;
            return deserializedAgentEvaluationRequest;
        });
    }
}

