/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.RedTeamsImpl;
import com.azure.ai.projects.models.RedTeam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class RedTeamsClient {
    private final RedTeamsImpl serviceClient;

    RedTeamsClient(RedTeamsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRedTeamWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getRedTeamWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRedTeams(RequestOptions requestOptions) {
        return this.serviceClient.listRedTeams(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createRedTeamWithResponse(BinaryData redTeam, RequestOptions requestOptions) {
        return this.serviceClient.createRedTeamWithResponse(redTeam, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedTeam getRedTeam(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (RedTeam)((BinaryData)this.getRedTeamWithResponse(name, requestOptions).getValue()).toObject(RedTeam.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RedTeam> listRedTeams() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listRedTeams(requestOptions).mapPage(bodyItemValue -> (RedTeam)bodyItemValue.toObject(RedTeam.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedTeam createRedTeam(RedTeam redTeam) {
        RequestOptions requestOptions = new RequestOptions();
        return (RedTeam)((BinaryData)this.createRedTeamWithResponse(BinaryData.fromObject((Object)redTeam), requestOptions).getValue()).toObject(RedTeam.class);
    }
}

