/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.RedTeamsImpl;
import com.azure.ai.projects.models.RedTeam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class RedTeamsAsyncClient {
    private final RedTeamsImpl serviceClient;

    RedTeamsAsyncClient(RedTeamsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRedTeamWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getRedTeamWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRedTeams(RequestOptions requestOptions) {
        return this.serviceClient.listRedTeamsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createRedTeamWithResponse(BinaryData redTeam, RequestOptions requestOptions) {
        return this.serviceClient.createRedTeamWithResponseAsync(redTeam, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedTeam> getRedTeam(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRedTeamWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RedTeam)protocolMethodData.toObject(RedTeam.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RedTeam> listRedTeams() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listRedTeams(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (RedTeam)protocolMethodData.toObject(RedTeam.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedTeam> createRedTeam(RedTeam redTeam) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createRedTeamWithResponse(BinaryData.fromObject((Object)redTeam), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RedTeam)protocolMethodData.toObject(RedTeam.class));
    }
}

