/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.EvaluationsImpl;
import com.azure.ai.projects.models.AgentEvaluation;
import com.azure.ai.projects.models.AgentEvaluationRequest;
import com.azure.ai.projects.models.Evaluation;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class EvaluationsClient {
    private final EvaluationsImpl serviceClient;

    EvaluationsClient(EvaluationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createAgentEvaluationWithResponse(BinaryData evaluation, RequestOptions requestOptions) {
        return this.serviceClient.createAgentEvaluationWithResponse(evaluation, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentEvaluation createAgentEvaluation(AgentEvaluationRequest evaluation) {
        RequestOptions requestOptions = new RequestOptions();
        return (AgentEvaluation)((BinaryData)this.createAgentEvaluationWithResponse(BinaryData.fromObject((Object)evaluation), requestOptions).getValue()).toObject(AgentEvaluation.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEvaluationWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEvaluationWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listEvaluations(RequestOptions requestOptions) {
        return this.serviceClient.listEvaluations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createEvaluationWithResponse(BinaryData evaluation, RequestOptions requestOptions) {
        return this.serviceClient.createEvaluationWithResponse(evaluation, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Evaluation getEvaluation(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (Evaluation)((BinaryData)this.getEvaluationWithResponse(name, requestOptions).getValue()).toObject(Evaluation.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Evaluation> listEvaluations() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listEvaluations(requestOptions).mapPage(bodyItemValue -> (Evaluation)bodyItemValue.toObject(Evaluation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Evaluation createEvaluation(Evaluation evaluation) {
        RequestOptions requestOptions = new RequestOptions();
        return (Evaluation)((BinaryData)this.createEvaluationWithResponse(BinaryData.fromObject((Object)evaluation), requestOptions).getValue()).toObject(Evaluation.class);
    }
}

