/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.EvaluationsImpl;
import com.azure.ai.projects.models.AgentEvaluation;
import com.azure.ai.projects.models.AgentEvaluationRequest;
import com.azure.ai.projects.models.Evaluation;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class EvaluationsAsyncClient {
    private final EvaluationsImpl serviceClient;

    EvaluationsAsyncClient(EvaluationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createAgentEvaluationWithResponse(BinaryData evaluation, RequestOptions requestOptions) {
        return this.serviceClient.createAgentEvaluationWithResponseAsync(evaluation, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AgentEvaluation> createAgentEvaluation(AgentEvaluationRequest evaluation) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createAgentEvaluationWithResponse(BinaryData.fromObject((Object)evaluation), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AgentEvaluation)protocolMethodData.toObject(AgentEvaluation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEvaluationWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEvaluationWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listEvaluations(RequestOptions requestOptions) {
        return this.serviceClient.listEvaluationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createEvaluationWithResponse(BinaryData evaluation, RequestOptions requestOptions) {
        return this.serviceClient.createEvaluationWithResponseAsync(evaluation, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Evaluation> getEvaluation(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEvaluationWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Evaluation)protocolMethodData.toObject(Evaluation.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Evaluation> listEvaluations() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listEvaluations(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Evaluation)protocolMethodData.toObject(Evaluation.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Evaluation> createEvaluation(Evaluation evaluation) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createEvaluationWithResponse(BinaryData.fromObject((Object)evaluation), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Evaluation)protocolMethodData.toObject(Evaluation.class));
    }
}

