/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.DeploymentsImpl;
import com.azure.ai.projects.models.Deployment;
import com.azure.ai.projects.models.DeploymentType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class DeploymentsClient {
    private final DeploymentsImpl serviceClient;

    DeploymentsClient(DeploymentsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeployments(RequestOptions requestOptions) {
        return this.serviceClient.listDeployments(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Deployment getDeployment(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (Deployment)((BinaryData)this.getDeploymentWithResponse(name, requestOptions).getValue()).toObject(Deployment.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Deployment> listDeployments(String modelPublisher, String modelName, DeploymentType deploymentType) {
        RequestOptions requestOptions = new RequestOptions();
        if (modelPublisher != null) {
            requestOptions.addQueryParam("modelPublisher", modelPublisher, false);
        }
        if (modelName != null) {
            requestOptions.addQueryParam("modelName", modelName, false);
        }
        if (deploymentType != null) {
            requestOptions.addQueryParam("deploymentType", deploymentType.toString(), false);
        }
        return this.serviceClient.listDeployments(requestOptions).mapPage(bodyItemValue -> (Deployment)bodyItemValue.toObject(Deployment.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Deployment> listDeployments() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listDeployments(requestOptions).mapPage(bodyItemValue -> (Deployment)bodyItemValue.toObject(Deployment.class));
    }
}

