/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.DatasetsImpl;
import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.AssetCredentialResult;
import com.azure.ai.projects.models.DatasetVersion;
import com.azure.ai.projects.models.FileDatasetVersion;
import com.azure.ai.projects.models.FolderDatasetVersion;
import com.azure.ai.projects.models.PendingUploadRequest;
import com.azure.ai.projects.models.PendingUploadResponse;
import com.azure.ai.projects.models.SasCredential;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobClientBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class DatasetsClient {
    private final ClientLogger logger = new ClientLogger(DatasetsClient.class);
    private final DatasetsImpl serviceClient;

    DatasetsClient(DatasetsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> pendingUploadWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.pendingUploadWithResponse(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCredentialsWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getCredentialsWithResponse(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PendingUploadResponse pendingUpload(String name, String version, PendingUploadRequest body) {
        RequestOptions requestOptions = new RequestOptions();
        return (PendingUploadResponse)((BinaryData)this.pendingUploadWithResponse(name, version, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(PendingUploadResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AssetCredentialResult getCredentials(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return (AssetCredentialResult)((BinaryData)this.getCredentialsWithResponse(name, version, requestOptions).getValue()).toObject(AssetCredentialResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileDatasetVersion createDatasetWithFile(String name, String version, Path filePath) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The provided path is not a file: " + filePath));
        }
        PendingUploadRequest body = new PendingUploadRequest();
        PendingUploadResponse pendingUploadResponse = this.pendingUpload(name, version, body);
        SasCredential credential = pendingUploadResponse.getBlobReference().getCredential();
        String blobUri = pendingUploadResponse.getBlobReference().getBlobUri();
        BlobClient blobClient = new BlobClientBuilder().endpoint(credential.getSasUri()).blobName(name).buildClient();
        blobClient.upload(BinaryData.fromFile((Path)filePath));
        RequestOptions requestOptions = new RequestOptions();
        FileDatasetVersion datasetVersion = (FileDatasetVersion)((BinaryData)this.createOrUpdateDatasetVersionWithResponse(name, version, BinaryData.fromObject((Object)new FileDatasetVersion().setDataUri(blobClient.getBlobUrl())), requestOptions).getValue()).toObject(FileDatasetVersion.class);
        return datasetVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FolderDatasetVersion createDatasetWithFolder(String name, String version, Path folderPath) throws IOException {
        if (!Files.isDirectory(folderPath, new LinkOption[0])) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The provided path is not a folder: " + folderPath));
        }
        PendingUploadRequest request = new PendingUploadRequest();
        PendingUploadResponse pendingUploadResponse = this.pendingUpload(name, version, request);
        String blobContainerUri = pendingUploadResponse.getBlobReference().getBlobUri();
        SasCredential credential = pendingUploadResponse.getBlobReference().getCredential();
        String containerUrl = blobContainerUri.substring(0, blobContainerUri.lastIndexOf(47));
        Files.walk(folderPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> {
            String relativePath = folderPath.relativize((Path)filePath).toString().replace('\\', '/');
            BlobClient blobClient = new BlobClientBuilder().endpoint(credential.getSasUri()).blobName(relativePath).buildClient();
            blobClient.upload(BinaryData.fromFile((Path)filePath), true);
        });
        RequestOptions requestOptions = new RequestOptions();
        FolderDatasetVersion datasetVersion = (FolderDatasetVersion)((BinaryData)this.createOrUpdateDatasetVersionWithResponse(name, version, BinaryData.fromObject((Object)new FolderDatasetVersion().setDataUri(containerUrl)), requestOptions).getValue()).toObject(FolderDatasetVersion.class);
        return datasetVersion;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDatasetVersions(String name, RequestOptions requestOptions) {
        return this.serviceClient.listDatasetVersions(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLatestDatasetVersions(RequestOptions requestOptions) {
        return this.serviceClient.listLatestDatasetVersions(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDatasetVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getDatasetVersionWithResponse(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDatasetVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.deleteDatasetVersionWithResponse(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDatasetVersionWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateDatasetVersionWithResponse(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetVersion> listDatasetVersions(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listDatasetVersions(name, requestOptions).mapPage(bodyItemValue -> (DatasetVersion)bodyItemValue.toObject(DatasetVersion.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetVersion> listLatestDatasetVersions() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listLatestDatasetVersions(requestOptions).mapPage(bodyItemValue -> (DatasetVersion)bodyItemValue.toObject(DatasetVersion.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetVersion getDatasetVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return (DatasetVersion)((BinaryData)this.getDatasetVersionWithResponse(name, version, requestOptions).getValue()).toObject(DatasetVersion.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDatasetVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteDatasetVersionWithResponse(name, version, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetVersion createOrUpdateDatasetVersion(String name, String version, DatasetVersion body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getDatasetVersionAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getDatasetVersionAccessor().prepareModelForJsonMergePatch(body, false);
        return (DatasetVersion)((BinaryData)this.createOrUpdateDatasetVersionWithResponse(name, version, bodyInBinaryData, requestOptions).getValue()).toObject(DatasetVersion.class);
    }
}

