// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DocumentAnalysisFeature. */
public final class DocumentAnalysisFeature extends ExpandableStringEnum<DocumentAnalysisFeature> {
    /** Static value ocrHighResolution for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature OCR_HIGH_RESOLUTION = fromString("ocrHighResolution");

    /** Static value languages for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature LANGUAGES = fromString("languages");

    /** Static value barcodes for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature BARCODES = fromString("barcodes");

    /** Static value formulas for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature FORMULAS = fromString("formulas");

    /** Static value keyValuePairs for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature KEY_VALUE_PAIRS = fromString("keyValuePairs");

    /** Static value styleFont for DocumentAnalysisFeature. */
    public static final DocumentAnalysisFeature STYLE_FONT = fromString("styleFont");

    /**
     * Creates a new instance of DocumentAnalysisFeature value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DocumentAnalysisFeature() {}

    /**
     * Creates or finds a DocumentAnalysisFeature from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DocumentAnalysisFeature.
     */
    @JsonCreator
    public static DocumentAnalysisFeature fromString(String name) {
        return fromString(name, DocumentAnalysisFeature.class);
    }

    /**
     * Gets known DocumentAnalysisFeature values.
     *
     * @return known DocumentAnalysisFeature values.
     */
    public static Collection<DocumentAnalysisFeature> values() {
        return values(DocumentAnalysisFeature.class);
    }
}
