// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List document models response object. */
@Immutable
public final class GetDocumentModelsResponse {
    /*
     * List of document models.
     */
    @JsonProperty(value = "value", required = true)
    private List<DocumentModelSummary> value;

    /*
     * Link to the next page of document models.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of GetDocumentModelsResponse class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    private GetDocumentModelsResponse(
            @JsonProperty(value = "value", required = true) List<DocumentModelSummary> value) {
        this.value = value;
    }

    /**
     * Get the value property: List of document models.
     *
     * @return the value value.
     */
    public List<DocumentModelSummary> getValue() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to the next page of document models.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
