// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An object representing the location and content of a table cell. */
@Immutable
public final class DocumentTableCell {
    /*
     * Table cell kind.
     */
    @JsonProperty(value = "kind")
    private DocumentTableCellKind kind;

    /*
     * Row index of the cell.
     */
    @JsonProperty(value = "rowIndex", required = true)
    private int rowIndex;

    /*
     * Column index of the cell.
     */
    @JsonProperty(value = "columnIndex", required = true)
    private int columnIndex;

    /*
     * Number of rows spanned by this cell.
     */
    @JsonProperty(value = "rowSpan")
    private Integer rowSpan;

    /*
     * Number of columns spanned by this cell.
     */
    @JsonProperty(value = "columnSpan")
    private Integer columnSpan;

    /*
     * Concatenated content of the table cell in reading order.
     */
    @JsonProperty(value = "content", required = true)
    private String content;

    /*
     * Bounding regions covering the table cell.
     */
    @JsonProperty(value = "boundingRegions")
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the table cell in the reading order concatenated content.
     */
    @JsonProperty(value = "spans", required = true)
    private List<DocumentSpan> spans;

    /**
     * Creates an instance of DocumentTableCell class.
     *
     * @param rowIndex the rowIndex value to set.
     * @param columnIndex the columnIndex value to set.
     * @param content the content value to set.
     * @param spans the spans value to set.
     */
    @JsonCreator
    private DocumentTableCell(
            @JsonProperty(value = "rowIndex", required = true) int rowIndex,
            @JsonProperty(value = "columnIndex", required = true) int columnIndex,
            @JsonProperty(value = "content", required = true) String content,
            @JsonProperty(value = "spans", required = true) List<DocumentSpan> spans) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.content = content;
        this.spans = spans;
    }

    /**
     * Get the kind property: Table cell kind.
     *
     * @return the kind value.
     */
    public DocumentTableCellKind getKind() {
        return this.kind;
    }

    /**
     * Get the rowIndex property: Row index of the cell.
     *
     * @return the rowIndex value.
     */
    public int getRowIndex() {
        return this.rowIndex;
    }

    /**
     * Get the columnIndex property: Column index of the cell.
     *
     * @return the columnIndex value.
     */
    public int getColumnIndex() {
        return this.columnIndex;
    }

    /**
     * Get the rowSpan property: Number of rows spanned by this cell.
     *
     * @return the rowSpan value.
     */
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    /**
     * Get the columnSpan property: Number of columns spanned by this cell.
     *
     * @return the columnSpan value.
     */
    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    /**
     * Get the content property: Concatenated content of the table cell in reading order.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the table cell.
     *
     * @return the boundingRegions value.
     */
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the table cell in the reading order concatenated content.
     *
     * @return the spans value.
     */
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }
}
