// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Document analysis result. */
@Immutable
public final class AnalyzeResult {
    /*
     * API version used to produce this result.
     */
    @JsonProperty(value = "apiVersion", required = true)
    private String apiVersion;

    /*
     * Document model ID used to produce this result.
     */
    @JsonProperty(value = "modelId", required = true)
    private String modelId;

    /*
     * Method used to compute string offset and length.
     */
    @JsonProperty(value = "stringIndexType", required = true)
    private StringIndexType stringIndexType;

    /*
     * Concatenate string representation of all textual and visual elements in reading order.
     */
    @JsonProperty(value = "content", required = true)
    private String content;

    /*
     * Analyzed pages.
     */
    @JsonProperty(value = "pages", required = true)
    private List<DocumentPage> pages;

    /*
     * Extracted paragraphs.
     */
    @JsonProperty(value = "paragraphs")
    private List<DocumentParagraph> paragraphs;

    /*
     * Extracted tables.
     */
    @JsonProperty(value = "tables")
    private List<DocumentTable> tables;

    /*
     * Extracted key-value pairs.
     */
    @JsonProperty(value = "keyValuePairs")
    private List<DocumentKeyValuePair> keyValuePairs;

    /*
     * Extracted font styles.
     */
    @JsonProperty(value = "styles")
    private List<DocumentStyle> styles;

    /*
     * Detected languages.
     */
    @JsonProperty(value = "languages")
    private List<DocumentLanguage> languages;

    /*
     * Extracted documents.
     */
    @JsonProperty(value = "documents")
    private List<Document> documents;

    /**
     * Creates an instance of AnalyzeResult class.
     *
     * @param apiVersion the apiVersion value to set.
     * @param modelId the modelId value to set.
     * @param stringIndexType the stringIndexType value to set.
     * @param content the content value to set.
     * @param pages the pages value to set.
     */
    @JsonCreator
    private AnalyzeResult(
            @JsonProperty(value = "apiVersion", required = true) String apiVersion,
            @JsonProperty(value = "modelId", required = true) String modelId,
            @JsonProperty(value = "stringIndexType", required = true) StringIndexType stringIndexType,
            @JsonProperty(value = "content", required = true) String content,
            @JsonProperty(value = "pages", required = true) List<DocumentPage> pages) {
        this.apiVersion = apiVersion;
        this.modelId = modelId;
        this.stringIndexType = stringIndexType;
        this.content = content;
        this.pages = pages;
    }

    /**
     * Get the apiVersion property: API version used to produce this result.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the modelId property: Document model ID used to produce this result.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the stringIndexType property: Method used to compute string offset and length.
     *
     * @return the stringIndexType value.
     */
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Get the content property: Concatenate string representation of all textual and visual elements in reading order.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }

    /**
     * Get the pages property: Analyzed pages.
     *
     * @return the pages value.
     */
    public List<DocumentPage> getPages() {
        return this.pages;
    }

    /**
     * Get the paragraphs property: Extracted paragraphs.
     *
     * @return the paragraphs value.
     */
    public List<DocumentParagraph> getParagraphs() {
        return this.paragraphs;
    }

    /**
     * Get the tables property: Extracted tables.
     *
     * @return the tables value.
     */
    public List<DocumentTable> getTables() {
        return this.tables;
    }

    /**
     * Get the keyValuePairs property: Extracted key-value pairs.
     *
     * @return the keyValuePairs value.
     */
    public List<DocumentKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    /**
     * Get the styles property: Extracted font styles.
     *
     * @return the styles value.
     */
    public List<DocumentStyle> getStyles() {
        return this.styles;
    }

    /**
     * Get the languages property: Detected languages.
     *
     * @return the languages value.
     */
    public List<DocumentLanguage> getLanguages() {
        return this.languages;
    }

    /**
     * Get the documents property: Extracted documents.
     *
     * @return the documents value.
     */
    public List<Document> getDocuments() {
        return this.documents;
    }
}
