/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training;

import com.azure.ai.formrecognizer.implementation.CustomFormModelHelper;
import com.azure.ai.formrecognizer.implementation.CustomFormModelInfoHelper;
import com.azure.ai.formrecognizer.implementation.CustomFormModelPropertiesHelper;
import com.azure.ai.formrecognizer.implementation.CustomFormSubmodelHelper;
import com.azure.ai.formrecognizer.implementation.TrainingDocumentInfoHelper;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.ErrorInformation;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.ModelStatus;
import com.azure.ai.formrecognizer.implementation.models.TrainResult;
import com.azure.ai.formrecognizer.models.FormRecognizerError;
import com.azure.ai.formrecognizer.training.models.CustomFormModel;
import com.azure.ai.formrecognizer.training.models.CustomFormModelField;
import com.azure.ai.formrecognizer.training.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.training.models.CustomFormModelProperties;
import com.azure.ai.formrecognizer.training.models.CustomFormModelStatus;
import com.azure.ai.formrecognizer.training.models.CustomFormSubmodel;
import com.azure.ai.formrecognizer.training.models.TrainingDocumentInfo;
import com.azure.ai.formrecognizer.training.models.TrainingStatus;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

final class CustomModelTransforms {
    private static final ClientLogger LOGGER = new ClientLogger(CustomModelTransforms.class);

    private CustomModelTransforms() {
    }

    static CustomFormModel toCustomFormModel(Model modelResponse) {
        ModelInfo modelInfo = modelResponse.getModelInfo();
        if (modelInfo.getStatus() == ModelStatus.INVALID) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Model Id %s returned with invalid status.", modelInfo.getModelId())));
        }
        List<TrainingDocumentInfo> trainingDocumentInfoList = null;
        List<FormRecognizerError> modelErrors = null;
        String modelId = modelInfo.getModelId().toString();
        if (modelResponse.getTrainResult() != null) {
            trainingDocumentInfoList = CustomModelTransforms.getTrainingDocumentList(modelResponse.getTrainResult().getTrainingDocuments(), modelId);
            modelErrors = CustomModelTransforms.transformTrainingErrors(modelResponse.getTrainResult().getErrors());
        }
        List<CustomFormSubmodel> subModelList = null;
        if (modelResponse.getKeys() != null) {
            subModelList = CustomModelTransforms.getUnlabeledSubmodels(modelResponse.getKeys().getClusters(), modelId);
        } else if (modelResponse.getTrainResult() != null && modelResponse.getTrainResult().getFields() != null) {
            Object formType = "custom:";
            formType = modelInfo.getModelName() != null ? (String)formType + modelInfo.getModelName() : (String)formType + modelInfo.getModelId();
            subModelList = CustomModelTransforms.getLabeledSubmodels(modelResponse, modelId, (String)formType);
        } else if (!CoreUtils.isNullOrEmpty(modelResponse.getComposedTrainResults())) {
            subModelList = CustomModelTransforms.getComposedSubmodels(modelResponse);
            trainingDocumentInfoList = new ArrayList<TrainingDocumentInfo>();
            for (TrainResult composedTrainResultItem : modelResponse.getComposedTrainResults()) {
                List<TrainingDocumentInfo> trainingDocumentSubModelList = CustomModelTransforms.getTrainingDocumentList(composedTrainResultItem.getTrainingDocuments(), composedTrainResultItem.getModelId().toString());
                trainingDocumentInfoList.addAll(trainingDocumentSubModelList);
            }
        }
        CustomFormModel customFormModel = new CustomFormModel(modelInfo.getModelId().toString(), CustomFormModelStatus.fromString(modelInfo.getStatus().toString()), modelInfo.getCreatedDateTime(), modelInfo.getLastUpdatedDateTime(), subModelList, modelErrors, trainingDocumentInfoList);
        CustomFormModelProperties customFormModelProperties = new CustomFormModelProperties();
        if (modelInfo.getAttributes() != null) {
            CustomFormModelPropertiesHelper.setIsComposed(customFormModelProperties, modelInfo.getAttributes().isComposed());
            CustomFormModelHelper.setCustomFormModelProperties(customFormModel, customFormModelProperties);
            if (modelInfo.getAttributes().isComposed().booleanValue()) {
                CustomFormModelHelper.setTrainingDocuments(customFormModel, trainingDocumentInfoList);
            }
        } else {
            CustomFormModelHelper.setCustomFormModelProperties(customFormModel, customFormModelProperties);
        }
        if (modelInfo.getModelName() != null) {
            CustomFormModelHelper.setModelName(customFormModel, modelInfo.getModelName());
        }
        return customFormModel;
    }

    private static List<TrainingDocumentInfo> getTrainingDocumentList(List<com.azure.ai.formrecognizer.implementation.models.TrainingDocumentInfo> trainingDocuments, String modelId) {
        return trainingDocuments.stream().map(trainingDocumentItem -> new TrainingDocumentInfo(trainingDocumentItem.getDocumentName(), TrainingStatus.fromString(trainingDocumentItem.getStatus().toString()), trainingDocumentItem.getPages(), CustomModelTransforms.transformTrainingErrors(trainingDocumentItem.getErrors()))).peek(trainingDocumentInfo -> TrainingDocumentInfoHelper.setModelId(trainingDocumentInfo, modelId)).collect(Collectors.toList());
    }

    private static List<CustomFormSubmodel> getLabeledSubmodels(Model modelResponse, String modelId, String formType) {
        TreeMap<String, CustomFormModelField> fieldMap = new TreeMap<String, CustomFormModelField>();
        ArrayList<CustomFormSubmodel> subModelList = new ArrayList<CustomFormSubmodel>();
        modelResponse.getTrainResult().getFields().forEach(formFieldsReport -> fieldMap.put(formFieldsReport.getFieldName(), new CustomFormModelField(null, formFieldsReport.getFieldName(), Float.valueOf(formFieldsReport.getAccuracy()))));
        CustomFormSubmodel customFormSubmodel = new CustomFormSubmodel(modelResponse.getTrainResult().getAverageModelAccuracy(), fieldMap, formType);
        CustomFormSubmodelHelper.setModelId(customFormSubmodel, modelId);
        subModelList.add(customFormSubmodel);
        return subModelList;
    }

    private static List<CustomFormSubmodel> getUnlabeledSubmodels(Map<String, List<String>> modelResponseClusters, String modelId) {
        ArrayList<CustomFormSubmodel> subModelList = new ArrayList<CustomFormSubmodel>();
        modelResponseClusters.forEach((clusterKey, clusterFields) -> {
            TreeMap<String, CustomFormModelField> fieldMap = new TreeMap<String, CustomFormModelField>();
            Utility.forEachWithIndex(clusterFields, (index, eachField) -> {
                String fieldName = "field-" + index;
                fieldMap.put(fieldName, new CustomFormModelField((String)eachField, fieldName, null));
            });
            CustomFormSubmodel customFormSubmodel = new CustomFormSubmodel(null, fieldMap, "form-" + clusterKey);
            CustomFormSubmodelHelper.setModelId(customFormSubmodel, modelId);
            subModelList.add(customFormSubmodel);
        });
        return subModelList;
    }

    private static List<CustomFormSubmodel> getComposedSubmodels(Model modelResponse) {
        ArrayList<CustomFormSubmodel> subModelList = new ArrayList<CustomFormSubmodel>();
        for (TrainResult composedTrainResultItem : modelResponse.getComposedTrainResults()) {
            String formType = "custom:" + composedTrainResultItem.getModelId().toString();
            TreeMap<String, CustomFormModelField> fieldMap = new TreeMap<String, CustomFormModelField>();
            composedTrainResultItem.getFields().forEach(formFieldsReport -> fieldMap.put(formFieldsReport.getFieldName(), new CustomFormModelField(null, formFieldsReport.getFieldName(), Float.valueOf(formFieldsReport.getAccuracy()))));
            CustomFormSubmodel customFormSubmodel = new CustomFormSubmodel(composedTrainResultItem.getAverageModelAccuracy(), fieldMap, formType);
            CustomFormSubmodelHelper.setModelId(customFormSubmodel, composedTrainResultItem.getModelId().toString());
            subModelList.add(customFormSubmodel);
        }
        return subModelList;
    }

    static List<CustomFormModelInfo> toCustomFormModelInfo(List<ModelInfo> modelInfoList) {
        return modelInfoList.stream().map(modelInfo -> {
            CustomFormModelInfo customFormModelInfo = new CustomFormModelInfo(modelInfo.getModelId().toString(), CustomFormModelStatus.fromString(modelInfo.getStatus().toString()), modelInfo.getCreatedDateTime(), modelInfo.getLastUpdatedDateTime());
            if (modelInfo.getAttributes() != null) {
                CustomFormModelProperties customFormModelProperties = new CustomFormModelProperties();
                CustomFormModelPropertiesHelper.setIsComposed(customFormModelProperties, modelInfo.getAttributes().isComposed());
                CustomFormModelInfoHelper.setCustomFormModelProperties(customFormModelInfo, customFormModelProperties);
            }
            if (modelInfo.getModelName() != null) {
                CustomFormModelInfoHelper.setModelName(customFormModelInfo, modelInfo.getModelName());
            }
            return customFormModelInfo;
        }).collect(Collectors.toList());
    }

    private static List<FormRecognizerError> transformTrainingErrors(List<ErrorInformation> trainingErrorList) {
        if (CoreUtils.isNullOrEmpty(trainingErrorList)) {
            return Collections.emptyList();
        }
        return trainingErrorList.stream().map(errorInformation -> new FormRecognizerError(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList());
    }
}

