/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentClassifierRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifyDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersBuildClassifierHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersClassifyDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentClassifiersResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DocumentClassifiersImpl {
    private final DocumentClassifiersService service;
    private final FormRecognizerClientImpl client;

    DocumentClassifiersImpl(FormRecognizerClientImpl client) {
        this.service = (DocumentClassifiersService)RestProxy.create(DocumentClassifiersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifierWithResponseAsync(BuildDocumentClassifierRequest buildRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.buildClassifier(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifierWithResponseAsync(BuildDocumentClassifierRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildClassifier(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void> buildClassifierWithResponse(BuildDocumentClassifierRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildClassifierSync(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(BuildDocumentClassifierRequest buildRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponseAsync(buildRequest), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(BuildDocumentClassifierRequest buildRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponseAsync(buildRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BuildDocumentClassifierRequest buildRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponse(buildRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BuildDocumentClassifierRequest buildRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponse(buildRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listClassifiers(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.listClassifiers(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiersAsync() {
        return new PagedFlux(() -> this.listClassifiersSinglePageAsync(), nextLink -> this.listClassifiersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiersAsync(Context context) {
        return new PagedFlux(() -> this.listClassifiersSinglePageAsync(context), nextLink -> this.listClassifiersNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersSinglePage() {
        String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res = this.service.listClassifiersSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersSinglePage(Context context) {
        String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res = this.service.listClassifiersSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers() {
        return new PagedIterable(() -> this.listClassifiersSinglePage(Context.NONE), nextLink -> this.listClassifiersNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers(Context context) {
        return new PagedIterable(() -> this.listClassifiersSinglePage(context), nextLink -> this.listClassifiersNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentClassifierDetails>> getClassifierWithResponseAsync(String classifierId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getClassifier(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentClassifierDetails>> getClassifierWithResponseAsync(String classifierId, Context context) {
        String accept = "application/json";
        return this.service.getClassifier(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifierAsync(String classifierId) {
        return this.getClassifierWithResponseAsync(classifierId).flatMap(res -> Mono.justOrEmpty((Object)((DocumentClassifierDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifierAsync(String classifierId, Context context) {
        return this.getClassifierWithResponseAsync(classifierId, context).flatMap(res -> Mono.justOrEmpty((Object)((DocumentClassifierDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentClassifierDetails> getClassifierWithResponse(String classifierId, Context context) {
        String accept = "application/json";
        return this.service.getClassifierSync(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentClassifierDetails getClassifier(String classifierId) {
        return (DocumentClassifierDetails)this.getClassifierWithResponse(classifierId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteClassifier(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId, Context context) {
        String accept = "application/json";
        return this.service.deleteClassifier(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteClassifierAsync(String classifierId) {
        return this.deleteClassifierWithResponseAsync(classifierId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteClassifierAsync(String classifierId, Context context) {
        return this.deleteClassifierWithResponseAsync(classifierId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, Context context) {
        String accept = "application/json";
        return this.service.deleteClassifierSync(this.client.getEndpoint(), classifierId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteClassifier(String classifierId) {
        this.deleteClassifierWithResponse(classifierId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest, Context context) {
        String accept = "application/json";
        return this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest, Context context) {
        String accept = "application/json";
        return this.service.classifyDocumentSync(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, Flux<ByteBuffer> classifyRequest, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), contentType, classifyRequest, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, Flux<ByteBuffer> classifyRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), contentType, classifyRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, Flux<ByteBuffer> classifyRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, contentType, stringIndexType, classifyRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, Flux<ByteBuffer> classifyRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, contentType, stringIndexType, classifyRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), contentType, classifyRequest, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), contentType, classifyRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.classifyDocumentSync(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), contentType, classifyRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, contentType, stringIndexType, classifyRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, contentType, stringIndexType, classifyRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, contentType, stringIndexType, classifyRequest, contentLength, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, ContentType contentType, StringIndexType stringIndexType, BinaryData classifyRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, contentType, stringIndexType, classifyRequest, contentLength, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        String accept = "application/json";
        return this.service.classifyDocument(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        String accept = "application/json";
        return this.service.classifyDocumentSync(this.client.getEndpoint(), classifierId, stringIndexType, this.client.getApiVersion(), classifyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getClassifyResultWithResponseAsync(String classifierId, String resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getClassifyResult(this.client.getEndpoint(), classifierId, resultId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getClassifyResultWithResponseAsync(String classifierId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getClassifyResult(this.client.getEndpoint(), classifierId, resultId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getClassifyResultAsync(String classifierId, String resultId) {
        return this.getClassifyResultWithResponseAsync(classifierId, resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getClassifyResultAsync(String classifierId, String resultId, Context context) {
        return this.getClassifyResultWithResponseAsync(classifierId, resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getClassifyResultWithResponse(String classifierId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getClassifyResultSync(this.client.getEndpoint(), classifierId, resultId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeResultOperation getClassifyResult(String classifierId, String resultId) {
        return (AnalyzeResultOperation)this.getClassifyResultWithResponse(classifierId, resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listClassifiersNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listClassifiersNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res = this.service.listClassifiersNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res = this.service.listClassifiersNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentClassifiersResponse)res.getValue()).getValue(), ((GetDocumentClassifiersResponse)res.getValue()).getNextLink(), null);
    }

    @Host(value="{endpoint}/formrecognizer")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface DocumentClassifiersService {
        @Post(value="/documentClassifiers:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifier(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentClassifierRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentClassifiers:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void> buildClassifierSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentClassifierRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentClassifiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentClassifiersResponse>> listClassifiers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentClassifiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentClassifiersResponse> listClassifiersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<DocumentClassifierDetails>> getClassifier(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<DocumentClassifierDetails> getClassifierSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteClassifier(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteClassifierSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ClassifyDocumentRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ClassifyDocumentRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @BodyParam(value="text/html") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @QueryParam(value="stringIndexType") StringIndexType var3, @QueryParam(value="api-version") String var4, @BodyParam(value="text/html") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/documentClassifiers/{classifierId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeResultOperation>> getClassifyResult(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/documentClassifiers/{classifierId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<AnalyzeResultOperation> getClassifyResultSync(@HostParam(value="endpoint") String var1, @PathParam(value="classifierId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentClassifiersResponse>> listClassifiersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentClassifiersResponse> listClassifiersNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

