// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Information about the extracted selection mark. */
@Fluent
public final class SelectionMark {
    /*
     * Bounding box of the selection mark.
     */
    @JsonProperty(value = "boundingBox", required = true)
    private List<Float> boundingBox;

    /*
     * Confidence value.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /*
     * State of the selection mark.
     */
    @JsonProperty(value = "state", required = true)
    private SelectionMarkState state;

    /** Creates an instance of SelectionMark class. */
    public SelectionMark() {}

    /**
     * Get the boundingBox property: Bounding box of the selection mark.
     *
     * @return the boundingBox value.
     */
    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    /**
     * Set the boundingBox property: Bounding box of the selection mark.
     *
     * @param boundingBox the boundingBox value to set.
     * @return the SelectionMark object itself.
     */
    public SelectionMark setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    /**
     * Get the confidence property: Confidence value.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence value.
     *
     * @param confidence the confidence value to set.
     * @return the SelectionMark object itself.
     */
    public SelectionMark setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * Get the state property: State of the selection mark.
     *
     * @return the state value.
     */
    public SelectionMarkState getState() {
        return this.state;
    }

    /**
     * Set the state property: State of the selection mark.
     *
     * @param state the state value to set.
     * @return the SelectionMark object itself.
     */
    public SelectionMark setState(SelectionMarkState state) {
        this.state = state;
        return this;
    }
}
