// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Detailed error. */
@Immutable
public final class InnerError {
    /*
     * Error code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /*
     * Error message.
     */
    @JsonProperty(value = "message")
    private String message;

    /*
     * Detailed error.
     */
    @JsonProperty(value = "innererror")
    private InnerError innererror;

    /**
     * Creates an instance of InnerError class.
     *
     * @param code the code value to set.
     */
    @JsonCreator
    private InnerError(@JsonProperty(value = "code", required = true) String code) {
        this.code = code;
    }

    /**
     * Get the code property: Error code.
     *
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: Error message.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the innererror property: Detailed error.
     *
     * @return the innererror value.
     */
    public InnerError getInnererror() {
        return this.innererror;
    }
}
