// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List Operations response object. */
@Immutable
public final class GetOperationsResponse {
    /*
     * List of operations.
     */
    @JsonProperty(value = "value", required = true)
    private List<OperationSummary> value;

    /*
     * Link to the next page of operations.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of GetOperationsResponse class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    private GetOperationsResponse(@JsonProperty(value = "value", required = true) List<OperationSummary> value) {
        this.value = value;
    }

    /**
     * Get the value property: List of operations.
     *
     * @return the value value.
     */
    public List<OperationSummary> getValue() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to the next page of operations.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
