// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Document type info. */
@Immutable
public final class DocumentTypeDetails {
    /*
     * Document model description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Custom document model build mode.
     */
    @JsonProperty(value = "buildMode")
    private DocumentBuildMode buildMode;

    /*
     * Description of the document semantic schema using a JSON Schema style syntax.
     */
    @JsonProperty(value = "fieldSchema", required = true)
    private Map<String, DocumentFieldSchema> fieldSchema;

    /*
     * Estimated confidence for each field.
     */
    @JsonProperty(value = "fieldConfidence")
    private Map<String, Float> fieldConfidence;

    /**
     * Creates an instance of DocumentTypeDetails class.
     *
     * @param fieldSchema the fieldSchema value to set.
     */
    @JsonCreator
    private DocumentTypeDetails(
            @JsonProperty(value = "fieldSchema", required = true) Map<String, DocumentFieldSchema> fieldSchema) {
        this.fieldSchema = fieldSchema;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     *
     * @return the buildMode value.
     */
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the fieldSchema property: Description of the document semantic schema using a JSON Schema style syntax.
     *
     * @return the fieldSchema value.
     */
    public Map<String, DocumentFieldSchema> getFieldSchema() {
        return this.fieldSchema;
    }

    /**
     * Get the fieldConfidence property: Estimated confidence for each field.
     *
     * @return the fieldConfidence value.
     */
    public Map<String, Float> getFieldConfidence() {
        return this.fieldConfidence;
    }
}
