// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** Document model info. */
@Immutable
public final class DocumentModelDetails {
    /*
     * Unique document model name.
     */
    @JsonProperty(value = "modelId", required = true)
    private String modelId;

    /*
     * Document model description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Date and time (UTC) when the document model was created.
     */
    @JsonProperty(value = "createdDateTime", required = true)
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the document model will expire.
     */
    @JsonProperty(value = "expirationDateTime")
    private OffsetDateTime expirationDateTime;

    /*
     * API version used to create this document model.
     */
    @JsonProperty(value = "apiVersion")
    private String apiVersion;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * Supported document types.
     */
    @JsonProperty(value = "docTypes")
    private Map<String, DocumentTypeDetails> docTypes;

    /**
     * Creates an instance of DocumentModelDetails class.
     *
     * @param modelId the modelId value to set.
     * @param createdDateTime the createdDateTime value to set.
     */
    @JsonCreator
    private DocumentModelDetails(
            @JsonProperty(value = "modelId", required = true) String modelId,
            @JsonProperty(value = "createdDateTime", required = true) OffsetDateTime createdDateTime) {
        this.modelId = modelId;
        this.createdDateTime = createdDateTime;
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the document model was created.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the expirationDateTime property: Date and time (UTC) when the document model will expire.
     *
     * @return the expirationDateTime value.
     */
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Get the apiVersion property: API version used to create this document model.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the docTypes property: Supported document types.
     *
     * @return the docTypes value.
     */
    public Map<String, DocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }
}
