// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing a form field with distinct field label (key) and field value (may be empty). */
@Immutable
public final class DocumentKeyValuePair {
    /*
     * Field label of the key-value pair.
     */
    @JsonProperty(value = "key", required = true)
    private DocumentKeyValueElement key;

    /*
     * Field value of the key-value pair.
     */
    @JsonProperty(value = "value")
    private DocumentKeyValueElement value;

    /*
     * Confidence of correctly extracting the key-value pair.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /**
     * Creates an instance of DocumentKeyValuePair class.
     *
     * @param key the key value to set.
     * @param confidence the confidence value to set.
     */
    @JsonCreator
    private DocumentKeyValuePair(
            @JsonProperty(value = "key", required = true) DocumentKeyValueElement key,
            @JsonProperty(value = "confidence", required = true) float confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    /**
     * Get the key property: Field label of the key-value pair.
     *
     * @return the key value.
     */
    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    /**
     * Get the value property: Field value of the key-value pair.
     *
     * @return the value value.
     */
    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the key-value pair.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }
}
