// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentClassifierRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifyDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersBuildClassifierHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersClassifyDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentClassifiersResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DocumentClassifiers. */
public final class DocumentClassifiersImpl {
    /** The proxy service used to perform REST calls. */
    private final DocumentClassifiersService service;

    /** The service client containing this operation class. */
    private final FormRecognizerClientImpl client;

    /**
     * Initializes an instance of DocumentClassifiersImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DocumentClassifiersImpl(FormRecognizerClientImpl client) {
        this.service =
                RestProxy.create(
                        DocumentClassifiersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FormRecognizerClientDocumentClassifiers to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{endpoint}/formrecognizer")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface DocumentClassifiersService {
        @Post("/documentClassifiers:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifier(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentClassifierRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void> buildClassifierSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentClassifierRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentClassifiersResponse>> listClassifiers(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentClassifiersResponse> listClassifiersSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers/{classifierId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<DocumentClassifierDetails>> getClassifier(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers/{classifierId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<DocumentClassifierDetails> getClassifierSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentClassifiers/{classifierId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> deleteClassifier(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentClassifiers/{classifierId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteClassifierSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ClassifyDocumentRequest classifyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ClassifyDocumentRequest classifyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> classifyRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData classifyRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData classifyRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("text/html") String classifyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("text/html") String classifyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers/{classifierId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeResultOperation>> getClassifyResult(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentClassifiers/{classifierId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<AnalyzeResultOperation> getClassifyResultSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("classifierId") String classifierId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentClassifiersResponse>> listClassifiersNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentClassifiersResponse> listClassifiersNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifierWithResponseAsync(
            BuildDocumentClassifierRequest buildRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.buildClassifier(
                                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context));
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void>> buildClassifierWithResponseAsync(
            BuildDocumentClassifierRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildClassifier(
                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersBuildClassifierHeaders, Void> buildClassifierWithResponse(
            BuildDocumentClassifierRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildClassifierSync(
                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(BuildDocumentClassifierRequest buildRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildClassifierWithResponseAsync(buildRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(
            BuildDocumentClassifierRequest buildRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildClassifierWithResponseAsync(buildRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BuildDocumentClassifierRequest buildRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildClassifierWithResponse(buildRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(
            BuildDocumentClassifierRequest buildRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildClassifierWithResponse(buildRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * List all document classifiers.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersSinglePageAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listClassifiers(
                                        this.client.getEndpoint(), this.client.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all document classifiers.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersSinglePageAsync(Context context) {
        final String accept = "application/json";
        return service.listClassifiers(this.client.getEndpoint(), this.client.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all document classifiers.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiersAsync() {
        return new PagedFlux<>(
                () -> listClassifiersSinglePageAsync(), nextLink -> listClassifiersNextSinglePageAsync(nextLink));
    }

    /**
     * List all document classifiers.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiersAsync(Context context) {
        return new PagedFlux<>(
                () -> listClassifiersSinglePageAsync(context),
                nextLink -> listClassifiersNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all document classifiers.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersSinglePage() {
        final String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res =
                service.listClassifiersSync(
                        this.client.getEndpoint(), this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List all document classifiers.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersSinglePage(Context context) {
        final String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res =
                service.listClassifiersSync(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List all document classifiers.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers() {
        return new PagedIterable<>(
                () -> listClassifiersSinglePage(Context.NONE), nextLink -> listClassifiersNextSinglePage(nextLink));
    }

    /**
     * List all document classifiers.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers(Context context) {
        return new PagedIterable<>(
                () -> listClassifiersSinglePage(context), nextLink -> listClassifiersNextSinglePage(nextLink, context));
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentClassifierDetails>> getClassifierWithResponseAsync(String classifierId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getClassifier(
                                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context));
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentClassifierDetails>> getClassifierWithResponseAsync(
            String classifierId, Context context) {
        final String accept = "application/json";
        return service.getClassifier(
                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifierAsync(String classifierId) {
        return getClassifierWithResponseAsync(classifierId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifierAsync(String classifierId, Context context) {
        return getClassifierWithResponseAsync(classifierId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DocumentClassifierDetails> getClassifierWithResponse(String classifierId, Context context) {
        final String accept = "application/json";
        return service.getClassifierSync(
                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentClassifierDetails getClassifier(String classifierId) {
        return getClassifierWithResponse(classifierId, Context.NONE).getValue();
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteClassifier(
                                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context));
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId, Context context) {
        final String accept = "application/json";
        return service.deleteClassifier(
                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteClassifierAsync(String classifierId) {
        return deleteClassifierWithResponseAsync(classifierId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteClassifierAsync(String classifierId, Context context) {
        return deleteClassifierWithResponseAsync(classifierId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, Context context) {
        final String accept = "application/json";
        return service.deleteClassifierSync(
                this.client.getEndpoint(), classifierId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteClassifier(String classifierId) {
        deleteClassifierWithResponse(classifierId, Context.NONE);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.classifyDocument(
                                this.client.getEndpoint(),
                                classifierId,
                                stringIndexType,
                                this.client.getApiVersion(),
                                classifyRequest,
                                accept,
                                context));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId,
            StringIndexType stringIndexType,
            ClassifyDocumentRequest classifyRequest,
            Context context) {
        final String accept = "application/json";
        return service.classifyDocument(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                classifyRequest,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(
            String classifierId,
            StringIndexType stringIndexType,
            ClassifyDocumentRequest classifyRequest,
            Context context) {
        final String accept = "application/json";
        return service.classifyDocumentSync(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                classifyRequest,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId,
            StringIndexType stringIndexType,
            ClassifyDocumentRequest classifyRequest,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId, StringIndexType stringIndexType, ClassifyDocumentRequest classifyRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId,
            StringIndexType stringIndexType,
            ClassifyDocumentRequest classifyRequest,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> classifyRequest,
            Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.classifyDocument(
                                this.client.getEndpoint(),
                                classifierId,
                                stringIndexType,
                                this.client.getApiVersion(),
                                contentType,
                                classifyRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> classifyRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.classifyDocument(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                contentType,
                classifyRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> classifyRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponseAsync(
                                classifierId, contentType, stringIndexType, classifyRequest, contentLength),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> classifyRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponseAsync(
                                classifierId, contentType, stringIndexType, classifyRequest, contentLength, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.classifyDocument(
                                this.client.getEndpoint(),
                                classifierId,
                                stringIndexType,
                                this.client.getApiVersion(),
                                contentType,
                                classifyRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.classifyDocument(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                contentType,
                classifyRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.classifyDocumentSync(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                contentType,
                classifyRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponseAsync(
                                classifierId, contentType, stringIndexType, classifyRequest, contentLength),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponseAsync(
                                classifierId, contentType, stringIndexType, classifyRequest, contentLength, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponse(
                                classifierId,
                                contentType,
                                stringIndexType,
                                classifyRequest,
                                contentLength,
                                Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param contentType Upload file type.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId,
            ContentType contentType,
            StringIndexType stringIndexType,
            BinaryData classifyRequest,
            Long contentLength,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.classifyDocumentWithResponse(
                                classifierId, contentType, stringIndexType, classifyRequest, contentLength, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.classifyDocument(
                                this.client.getEndpoint(),
                                classifierId,
                                stringIndexType,
                                this.client.getApiVersion(),
                                classifyRequest,
                                accept,
                                context));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void>> classifyDocumentWithResponseAsync(
            String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        final String accept = "application/json";
        return service.classifyDocument(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                classifyRequest,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> classifyDocumentWithResponse(
            String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        final String accept = "application/json";
        return service.classifyDocumentSync(
                this.client.getEndpoint(),
                classifierId,
                stringIndexType,
                this.client.getApiVersion(),
                classifyRequest,
                accept,
                context);
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(
            String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponseAsync(classifierId, stringIndexType, classifyRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId, StringIndexType stringIndexType, String classifyRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param stringIndexType Method used to compute string offset and length.
     * @param classifyRequest Classify request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(
            String classifierId, StringIndexType stringIndexType, String classifyRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.classifyDocumentWithResponse(classifierId, stringIndexType, classifyRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getClassifyResultWithResponseAsync(
            String classifierId, String resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getClassifyResult(
                                this.client.getEndpoint(),
                                classifierId,
                                resultId,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getClassifyResultWithResponseAsync(
            String classifierId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getClassifyResult(
                this.client.getEndpoint(), classifierId, resultId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getClassifyResultAsync(String classifierId, String resultId) {
        return getClassifyResultWithResponseAsync(classifierId, resultId)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getClassifyResultAsync(String classifierId, String resultId, Context context) {
        return getClassifyResultWithResponseAsync(classifierId, resultId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getClassifyResultWithResponse(
            String classifierId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getClassifyResultSync(
                this.client.getEndpoint(), classifierId, resultId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the result of document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document classifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeResultOperation getClassifyResult(String classifierId, String resultId) {
        return getClassifyResultWithResponse(classifierId, resultId, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listClassifiersNext(nextLink, this.client.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentClassifierDetails>> listClassifiersNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.listClassifiersNext(nextLink, this.client.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersNextSinglePage(String nextLink) {
        final String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res =
                service.listClassifiersNextSync(nextLink, this.client.getEndpoint(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document classifiers response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentClassifierDetails> listClassifiersNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        Response<GetDocumentClassifiersResponse> res =
                service.listClassifiersNextSync(nextLink, this.client.getEndpoint(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }
}
