/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training.models;

import com.azure.ai.formrecognizer.implementation.TrainingDocumentInfoHelper;
import com.azure.ai.formrecognizer.models.FormRecognizerError;
import com.azure.ai.formrecognizer.training.models.TrainingStatus;
import java.util.Collections;
import java.util.List;

public final class TrainingDocumentInfo {
    private final String name;
    private final TrainingStatus status;
    private final int pageCount;
    private final List<FormRecognizerError> errors;
    private String modelId;

    public TrainingDocumentInfo(String name, TrainingStatus status, int pageCount, List<FormRecognizerError> errors) {
        this.name = name;
        this.status = status;
        this.pageCount = pageCount;
        this.errors = errors == null ? null : Collections.unmodifiableList(errors);
    }

    public String getName() {
        return this.name;
    }

    public TrainingStatus getStatus() {
        return this.status;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public List<FormRecognizerError> getErrors() {
        return this.errors;
    }

    public String getModelId() {
        return this.modelId;
    }

    private void setModelId(String modelId) {
        this.modelId = modelId;
    }

    static {
        TrainingDocumentInfoHelper.setAccessor(new TrainingDocumentInfoHelper.TrainingDocumentInfoAccessor(){

            @Override
            public void setModelId(TrainingDocumentInfo documentInfo, String modelId) {
                documentInfo.setModelId(modelId);
            }
        });
    }
}

