/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training.models;

import com.azure.ai.formrecognizer.implementation.CustomFormSubmodelHelper;
import com.azure.ai.formrecognizer.training.models.CustomFormModelField;
import java.util.Collections;
import java.util.Map;

public final class CustomFormSubmodel {
    private final Float accuracy;
    private final Map<String, CustomFormModelField> fields;
    private final String formType;
    private String modelId;

    public CustomFormSubmodel(Float accuracy, Map<String, CustomFormModelField> fields, String formType) {
        this.accuracy = accuracy;
        this.fields = fields == null ? null : Collections.unmodifiableMap(fields);
        this.formType = formType;
    }

    public Float getAccuracy() {
        return this.accuracy;
    }

    public String getFormType() {
        return this.formType;
    }

    public Map<String, CustomFormModelField> getFields() {
        return this.fields;
    }

    public String getModelId() {
        return this.modelId;
    }

    private void setModelId(String modelId) {
        this.modelId = modelId;
    }

    static {
        CustomFormSubmodelHelper.setAccessor(new CustomFormSubmodelHelper.CustomFormSubmodelAccessor(){

            @Override
            public void setModelId(CustomFormSubmodel formSubmodel, String modelId) {
                formSubmodel.setModelId(modelId);
            }
        });
    }
}

