// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Request parameter that contains authorization claims for copy operation. */
@Fluent
public final class CopyAuthorizationResult {
    /*
     * Model identifier.
     */
    @JsonProperty(value = "modelId", required = true)
    private String modelId;

    /*
     * Token claim used to authorize the request.
     */
    @JsonProperty(value = "accessToken", required = true)
    private String accessToken;

    /*
     * The time when the access token expires. The date is represented as the
     * number of seconds from 1970-01-01T0:0:0Z UTC until the expiration time.
     */
    @JsonProperty(value = "expirationDateTimeTicks", required = true)
    private long expirationDateTimeTicks;

    /**
     * Get the modelId property: Model identifier.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Set the modelId property: Model identifier.
     *
     * @param modelId the modelId value to set.
     * @return the CopyAuthorizationResult object itself.
     */
    public CopyAuthorizationResult setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    /**
     * Get the accessToken property: Token claim used to authorize the request.
     *
     * @return the accessToken value.
     */
    public String getAccessToken() {
        return this.accessToken;
    }

    /**
     * Set the accessToken property: Token claim used to authorize the request.
     *
     * @param accessToken the accessToken value to set.
     * @return the CopyAuthorizationResult object itself.
     */
    public CopyAuthorizationResult setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * Get the expirationDateTimeTicks property: The time when the access token expires. The date is represented as the
     * number of seconds from 1970-01-01T0:0:0Z UTC until the expiration time.
     *
     * @return the expirationDateTimeTicks value.
     */
    public long getExpirationDateTimeTicks() {
        return this.expirationDateTimeTicks;
    }

    /**
     * Set the expirationDateTimeTicks property: The time when the access token expires. The date is represented as the
     * number of seconds from 1970-01-01T0:0:0Z UTC until the expiration time.
     *
     * @param expirationDateTimeTicks the expirationDateTimeTicks value to set.
     * @return the CopyAuthorizationResult object itself.
     */
    public CopyAuthorizationResult setExpirationDateTimeTicks(long expirationDateTimeTicks) {
        this.expirationDateTimeTicks = expirationDateTimeTicks;
        return this;
    }
}
