// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** General information regarding the current resource. */
@Immutable
public final class ResourceDetails {
    /*
     * Details regarding custom document models.
     */
    @JsonProperty(value = "customDocumentModels", required = true)
    private CustomDocumentModelsDetails customDocumentModels;

    /*
     * Quota used, limit, and next reset date/time.
     */
    @JsonProperty(value = "customNeuralDocumentModelBuilds", required = true)
    private QuotaDetails customNeuralDocumentModelBuilds;

    /**
     * Creates an instance of ResourceDetails class.
     *
     * @param customDocumentModels the customDocumentModels value to set.
     * @param customNeuralDocumentModelBuilds the customNeuralDocumentModelBuilds value to set.
     */
    @JsonCreator
    public ResourceDetails(
            @JsonProperty(value = "customDocumentModels", required = true)
                    CustomDocumentModelsDetails customDocumentModels,
            @JsonProperty(value = "customNeuralDocumentModelBuilds", required = true)
                    QuotaDetails customNeuralDocumentModelBuilds) {
        this.customDocumentModels = customDocumentModels;
        this.customNeuralDocumentModelBuilds = customNeuralDocumentModelBuilds;
    }

    /**
     * Get the customDocumentModels property: Details regarding custom document models.
     *
     * @return the customDocumentModels value.
     */
    public CustomDocumentModelsDetails getCustomDocumentModels() {
        return this.customDocumentModels;
    }

    /**
     * Get the customNeuralDocumentModelBuilds property: Quota used, limit, and next reset date/time.
     *
     * @return the customNeuralDocumentModelBuilds value.
     */
    public QuotaDetails getCustomNeuralDocumentModelBuilds() {
        return this.customNeuralDocumentModelBuilds;
    }
}
