// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Quota used, limit, and next reset date/time. */
@Immutable
public final class QuotaDetails {
    /*
     * Amount of the resource quota used.
     */
    @JsonProperty(value = "used", required = true)
    private int used;

    /*
     * Resource quota limit.
     */
    @JsonProperty(value = "quota", required = true)
    private int quota;

    /*
     * Date/time when the resource quota usage will be reset.
     */
    @JsonProperty(value = "quotaResetDateTime", required = true)
    private OffsetDateTime quotaResetDateTime;

    /**
     * Creates an instance of QuotaDetails class.
     *
     * @param used the used value to set.
     * @param quota the quota value to set.
     * @param quotaResetDateTime the quotaResetDateTime value to set.
     */
    @JsonCreator
    public QuotaDetails(
            @JsonProperty(value = "used", required = true) int used,
            @JsonProperty(value = "quota", required = true) int quota,
            @JsonProperty(value = "quotaResetDateTime", required = true) OffsetDateTime quotaResetDateTime) {
        this.used = used;
        this.quota = quota;
        this.quotaResetDateTime = quotaResetDateTime;
    }

    /**
     * Get the used property: Amount of the resource quota used.
     *
     * @return the used value.
     */
    public int getUsed() {
        return this.used;
    }

    /**
     * Get the quota property: Resource quota limit.
     *
     * @return the quota value.
     */
    public int getQuota() {
        return this.quota;
    }

    /**
     * Get the quotaResetDateTime property: Date/time when the resource quota usage will be reset.
     *
     * @return the quotaResetDateTime value.
     */
    public OffsetDateTime getQuotaResetDateTime() {
        return this.quotaResetDateTime;
    }
}
