// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List document classifiers response object. */
@Fluent
public final class GetDocumentClassifiersResponse {
    /*
     * List of document classifiers.
     */
    @JsonProperty(value = "value", required = true)
    private List<DocumentClassifierDetails> value;

    /*
     * Link to the next page of document classifiers.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of GetDocumentClassifiersResponse class.
     *
     * @param value the value value to set.
     */
    @JsonCreator
    public GetDocumentClassifiersResponse(
            @JsonProperty(value = "value", required = true) List<DocumentClassifierDetails> value) {
        this.value = value;
    }

    /**
     * Get the value property: List of document classifiers.
     *
     * @return the value value.
     */
    public List<DocumentClassifierDetails> getValue() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to the next page of document classifiers.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next page of document classifiers.
     *
     * @param nextLink the nextLink value to set.
     * @return the GetDocumentClassifiersResponse object itself.
     */
    public GetDocumentClassifiersResponse setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }
}
