// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contiguous region of the concatenated content property, specified as an offset and length. */
@Immutable
public final class DocumentSpan {
    /*
     * Zero-based index of the content represented by the span.
     */
    @JsonProperty(value = "offset", required = true)
    private int offset;

    /*
     * Number of characters in the content represented by the span.
     */
    @JsonProperty(value = "length", required = true)
    private int length;

    /**
     * Creates an instance of DocumentSpan class.
     *
     * @param offset the offset value to set.
     * @param length the length value to set.
     */
    @JsonCreator
    public DocumentSpan(
            @JsonProperty(value = "offset", required = true) int offset,
            @JsonProperty(value = "length", required = true) int length) {
        this.offset = offset;
        this.length = length;
    }

    /**
     * Get the offset property: Zero-based index of the content represented by the span.
     *
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Get the length property: Number of characters in the content represented by the span.
     *
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }
}
