// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing a form field with distinct field label (key) and field value (may be empty). */
@Fluent
public final class DocumentKeyValuePair {
    /*
     * Field label of the key-value pair.
     */
    @JsonProperty(value = "key", required = true)
    private DocumentKeyValueElement key;

    /*
     * Field value of the key-value pair.
     */
    @JsonProperty(value = "value")
    private DocumentKeyValueElement value;

    /*
     * Common name of the key-value pair.
     */
    @JsonProperty(value = "commonName")
    private String commonName;

    /*
     * Confidence of correctly extracting the key-value pair.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /**
     * Creates an instance of DocumentKeyValuePair class.
     *
     * @param key the key value to set.
     * @param confidence the confidence value to set.
     */
    @JsonCreator
    public DocumentKeyValuePair(
            @JsonProperty(value = "key", required = true) DocumentKeyValueElement key,
            @JsonProperty(value = "confidence", required = true) float confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    /**
     * Get the key property: Field label of the key-value pair.
     *
     * @return the key value.
     */
    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    /**
     * Get the value property: Field value of the key-value pair.
     *
     * @return the value value.
     */
    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    /**
     * Set the value property: Field value of the key-value pair.
     *
     * @param value the value value to set.
     * @return the DocumentKeyValuePair object itself.
     */
    public DocumentKeyValuePair setValue(DocumentKeyValueElement value) {
        this.value = value;
        return this;
    }

    /**
     * Get the commonName property: Common name of the key-value pair.
     *
     * @return the commonName value.
     */
    public String getCommonName() {
        return this.commonName;
    }

    /**
     * Set the commonName property: Common name of the key-value pair.
     *
     * @param commonName the commonName value to set.
     * @return the DocumentKeyValuePair object itself.
     */
    public DocumentKeyValuePair setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the key-value pair.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }
}
