// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Description of the field semantic schema using a JSON Schema style syntax. */
@Fluent
public final class DocumentFieldSchema {
    /*
     * Semantic data type of the field value.
     */
    @JsonProperty(value = "type", required = true)
    private DocumentFieldType type;

    /*
     * Field description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Example field content.
     */
    @JsonProperty(value = "example")
    private String example;

    /*
     * Field type schema of each array element.
     */
    @JsonProperty(value = "items")
    private DocumentFieldSchema items;

    /*
     * Named sub-fields of the object field.
     */
    @JsonProperty(value = "properties")
    private Map<String, DocumentFieldSchema> properties;

    /**
     * Creates an instance of DocumentFieldSchema class.
     *
     * @param type the type value to set.
     */
    @JsonCreator
    public DocumentFieldSchema(@JsonProperty(value = "type", required = true) DocumentFieldType type) {
        this.type = type;
    }

    /**
     * Get the type property: Semantic data type of the field value.
     *
     * @return the type value.
     */
    public DocumentFieldType getType() {
        return this.type;
    }

    /**
     * Get the description property: Field description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Field description.
     *
     * @param description the description value to set.
     * @return the DocumentFieldSchema object itself.
     */
    public DocumentFieldSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the example property: Example field content.
     *
     * @return the example value.
     */
    public String getExample() {
        return this.example;
    }

    /**
     * Set the example property: Example field content.
     *
     * @param example the example value to set.
     * @return the DocumentFieldSchema object itself.
     */
    public DocumentFieldSchema setExample(String example) {
        this.example = example;
        return this;
    }

    /**
     * Get the items property: Field type schema of each array element.
     *
     * @return the items value.
     */
    public DocumentFieldSchema getItems() {
        return this.items;
    }

    /**
     * Set the items property: Field type schema of each array element.
     *
     * @param items the items value to set.
     * @return the DocumentFieldSchema object itself.
     */
    public DocumentFieldSchema setItems(DocumentFieldSchema items) {
        this.items = items;
        return this;
    }

    /**
     * Get the properties property: Named sub-fields of the object field.
     *
     * @return the properties value.
     */
    public Map<String, DocumentFieldSchema> getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: Named sub-fields of the object field.
     *
     * @param properties the properties value to set.
     * @return the DocumentFieldSchema object itself.
     */
    public DocumentFieldSchema setProperties(Map<String, DocumentFieldSchema> properties) {
        this.properties = properties;
        return this;
    }
}
