// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A barcode object. */
@Fluent
public final class DocumentBarcode {
    /*
     * Barcode kind.
     */
    @JsonProperty(value = "kind", required = true)
    private DocumentBarcodeKind kind;

    /*
     * Barcode value
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /*
     * Bounding polygon of the barcode.
     */
    @JsonProperty(value = "polygon")
    private List<Float> polygon;

    /*
     * Location of the barcode in the reading order concatenated content.
     */
    @JsonProperty(value = "span", required = true)
    private DocumentSpan span;

    /*
     * Confidence of correctly extracting the barcode.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /**
     * Creates an instance of DocumentBarcode class.
     *
     * @param kind the kind value to set.
     * @param value the value value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    @JsonCreator
    public DocumentBarcode(
            @JsonProperty(value = "kind", required = true) DocumentBarcodeKind kind,
            @JsonProperty(value = "value", required = true) String value,
            @JsonProperty(value = "span", required = true) DocumentSpan span,
            @JsonProperty(value = "confidence", required = true) float confidence) {
        this.kind = kind;
        this.value = value;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the kind property: Barcode kind.
     *
     * @return the kind value.
     */
    public DocumentBarcodeKind getKind() {
        return this.kind;
    }

    /**
     * Get the value property: Barcode value.
     *
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Get the polygon property: Bounding polygon of the barcode.
     *
     * @return the polygon value.
     */
    public List<Float> getPolygon() {
        return this.polygon;
    }

    /**
     * Set the polygon property: Bounding polygon of the barcode.
     *
     * @param polygon the polygon value to set.
     * @return the DocumentBarcode object itself.
     */
    public DocumentBarcode setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    /**
     * Get the span property: Location of the barcode in the reading order concatenated content.
     *
     * @return the span value.
     */
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the barcode.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }
}
