// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Request body to build a new custom document classifier. */
@Fluent
public final class BuildDocumentClassifierRequest {
    /*
     * Unique document classifier name.
     */
    @JsonProperty(value = "classifierId", required = true)
    private String classifierId;

    /*
     * Document classifier description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * List of document types to classify against.
     */
    @JsonProperty(value = "docTypes", required = true)
    private Map<String, ClassifierDocumentTypeDetails> docTypes;

    /**
     * Creates an instance of BuildDocumentClassifierRequest class.
     *
     * @param classifierId the classifierId value to set.
     * @param docTypes the docTypes value to set.
     */
    @JsonCreator
    public BuildDocumentClassifierRequest(
            @JsonProperty(value = "classifierId", required = true) String classifierId,
            @JsonProperty(value = "docTypes", required = true) Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.classifierId = classifierId;
        this.docTypes = docTypes;
    }

    /**
     * Get the classifierId property: Unique document classifier name.
     *
     * @return the classifierId value.
     */
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the description property: Document classifier description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document classifier description.
     *
     * @param description the description value to set.
     * @return the BuildDocumentClassifierRequest object itself.
     */
    public BuildDocumentClassifierRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the docTypes property: List of document types to classify against.
     *
     * @return the docTypes value.
     */
    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }
}
