// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Request body to authorize document model copy. */
@Fluent
public final class AuthorizeCopyRequest {
    /*
     * Unique document model name.
     */
    @JsonProperty(value = "modelId", required = true)
    private String modelId;

    /*
     * Document model description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Creates an instance of AuthorizeCopyRequest class.
     *
     * @param modelId the modelId value to set.
     */
    @JsonCreator
    public AuthorizeCopyRequest(@JsonProperty(value = "modelId", required = true) String modelId) {
        this.modelId = modelId;
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the AuthorizeCopyRequest object itself.
     */
    public AuthorizeCopyRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the AuthorizeCopyRequest object itself.
     */
    public AuthorizeCopyRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }
}
