// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentAnalysisFeature;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsBuildModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsComposeModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsCopyModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentModelsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DocumentModels. */
public final class DocumentModelsImpl {
    /** The proxy service used to perform REST calls. */
    private final DocumentModelsService service;

    /** The service client containing this operation class. */
    private final FormRecognizerClientImpl client;

    /**
     * Initializes an instance of DocumentModelsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DocumentModelsImpl(FormRecognizerClientImpl client) {
        this.service =
                RestProxy.create(DocumentModelsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FormRecognizerClientDocumentModels to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}/formrecognizer")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface DocumentModelsService {
        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @BodyParam("text/html") String analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("features") String features,
                @QueryParam("queryFields") String queryFields,
                @BodyParam("text/html") String analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeResultOperation>> getAnalyzeResult(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<AnalyzeResultOperation> getAnalyzeResultSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModel(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentModelRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsBuildModelHeaders, Void> buildModelSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentModelRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModel(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsComposeModelHeaders, Void> composeModelSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyAuthorization>> authorizeModelCopy(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<CopyAuthorization> authorizeModelCopySync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelTo(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") CopyAuthorization copyToRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") CopyAuthorization copyToRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> listModels(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> listModelsSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<DocumentModelDetails>> getModel(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<DocumentModelDetails> getModelSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> deleteModel(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteModelSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> listModelsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> listModelsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.client.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.client.getApiVersion(),
                                featuresConverted,
                                queryFieldsConverted,
                                analyzeRequest,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocument(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId, pages, locale, stringIndexType, features, queryFields, analyzeRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.client.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.client.getApiVersion(),
                                featuresConverted,
                                queryFieldsConverted,
                                contentType,
                                analyzeRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocument(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength,
                                context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.client.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.client.getApiVersion(),
                                featuresConverted,
                                queryFieldsConverted,
                                contentType,
                                analyzeRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocument(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength,
                                context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength,
                                Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                contentLength,
                                context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.client.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.client.getApiVersion(),
                                featuresConverted,
                                queryFieldsConverted,
                                analyzeRequest,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocument(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest,
            Context context) {
        final String accept = "application/json";
        String featuresConverted =
                (features == null)
                        ? null
                        : features.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String queryFieldsConverted =
                (queryFields == null)
                        ? null
                        : queryFields.stream()
                                .map(value -> Objects.toString(value, ""))
                                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(
                this.client.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.client.getApiVersion(),
                featuresConverted,
                queryFieldsConverted,
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId, pages, locale, stringIndexType, features, queryFields, analyzeRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param queryFields List of additional fields to extract. Ex. "NumberOfGuests,StoreNumber".
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            List<DocumentAnalysisFeature> features,
            List<String> queryFields,
            String analyzeRequest,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                features,
                                queryFields,
                                analyzeRequest,
                                context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(String modelId, String resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeResult(
                                this.client.getEndpoint(),
                                modelId,
                                resultId,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(
            String modelId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeResult(
                this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId, Context context) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeResultWithResponse(
            String modelId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeResultSync(
                this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeResult(String modelId, String resultId) {
        return getAnalyzeResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModelWithResponseAsync(
            BuildDocumentModelRequest buildRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.buildModel(
                                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModelWithResponseAsync(
            BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildModel(
                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsBuildModelHeaders, Void> buildModelWithResponse(
            BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildModelSync(
                this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildModelWithResponseAsync(buildRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(
            BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildModelWithResponseAsync(buildRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildModelWithResponse(buildRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildModelWithResponse(buildRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModelWithResponseAsync(
            ComposeDocumentModelRequest composeRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.composeModel(
                                this.client.getEndpoint(),
                                this.client.getApiVersion(),
                                composeRequest,
                                accept,
                                context));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModelWithResponseAsync(
            ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeModel(
                this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsComposeModelHeaders, Void> composeModelWithResponse(
            ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeModelSync(
                this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.composeModelWithResponseAsync(composeRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(
            ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.composeModelWithResponseAsync(composeRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.composeModelWithResponse(composeRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(
            ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.composeModelWithResponse(composeRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeModelCopyWithResponseAsync(
            AuthorizeCopyRequest authorizeCopyRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.authorizeModelCopy(
                                this.client.getEndpoint(),
                                this.client.getApiVersion(),
                                authorizeCopyRequest,
                                accept,
                                context));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeModelCopyWithResponseAsync(
            AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopy(
                this.client.getEndpoint(), this.client.getApiVersion(), authorizeCopyRequest, accept, context);
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeModelCopyWithResponseAsync(authorizeCopyRequest)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return authorizeModelCopyWithResponseAsync(authorizeCopyRequest, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeModelCopyWithResponse(
            AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopySync(
                this.client.getEndpoint(), this.client.getApiVersion(), authorizeCopyRequest, accept, context);
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyAuthorization authorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeModelCopyWithResponse(authorizeCopyRequest, Context.NONE).getValue();
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(
            String modelId, CopyAuthorization copyToRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.copyModelTo(
                                this.client.getEndpoint(),
                                modelId,
                                this.client.getApiVersion(),
                                copyToRequest,
                                accept,
                                context));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyModelTo(
                this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, accept, context);
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToWithResponse(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyModelToSync(
                this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, accept, context);
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.copyModelToWithResponseAsync(modelId, copyToRequest),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, context),
                new DefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.copyModelToWithResponse(modelId, copyToRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.copyModelToWithResponse(modelId, copyToRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.client.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listModels(
                                        this.client.getEndpoint(), this.client.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync(Context context) {
        final String accept = "application/json";
        return service.listModels(this.client.getEndpoint(), this.client.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync() {
        return new PagedFlux<>(() -> listModelsSinglePageAsync(), nextLink -> listModelsNextSinglePageAsync(nextLink));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync(Context context) {
        return new PagedFlux<>(
                () -> listModelsSinglePageAsync(context), nextLink -> listModelsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage() {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage(Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels() {
        return new PagedIterable<>(
                () -> listModelsSinglePage(Context.NONE), nextLink -> listModelsNextSinglePage(nextLink));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels(Context context) {
        return new PagedIterable<>(
                () -> listModelsSinglePage(context), nextLink -> listModelsNextSinglePage(nextLink, context));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getModel(
                                this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.getModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId) {
        return getModelWithResponseAsync(modelId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId, Context context) {
        return getModelWithResponseAsync(modelId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DocumentModelDetails> getModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.getModelSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        return getModelWithResponse(modelId, Context.NONE).getValue();
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteModel(
                                this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context));
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId) {
        return deleteModelWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId, Context context) {
        return deleteModelWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteModelSync(
                this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        deleteModelWithResponse(modelId, Context.NONE);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listModelsNext(nextLink, this.client.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listModelsNext(nextLink, this.client.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.listModelsNextSync(nextLink, this.client.getEndpoint(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.listModelsNextSync(nextLink, this.client.getEndpoint(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }
}
