/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training;

import com.azure.ai.formrecognizer.FormRecognizerClient;
import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.models.CreateComposedModelOptions;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.training.FormTrainingAsyncClient;
import com.azure.ai.formrecognizer.training.FormTrainingClientBuilder;
import com.azure.ai.formrecognizer.training.models.AccountProperties;
import com.azure.ai.formrecognizer.training.models.CopyAuthorization;
import com.azure.ai.formrecognizer.training.models.CustomFormModel;
import com.azure.ai.formrecognizer.training.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.training.models.TrainingOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.List;

@ServiceClient(builder=FormTrainingClientBuilder.class)
public final class FormTrainingClient {
    private final FormTrainingAsyncClient client;

    FormTrainingClient(FormTrainingAsyncClient formTrainingAsyncClient) {
        this.client = formTrainingAsyncClient;
    }

    public FormRecognizerClient getFormRecognizerClient() {
        return new FormRecognizerClientBuilder().endpoint(this.client.getEndpoint()).pipeline(this.client.getHttpPipeline()).buildClient();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels) {
        return this.beginTraining(trainingFilesUrl, useTrainingLabels, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels, TrainingOptions trainingOptions, Context context) {
        return this.client.beginTraining(trainingFilesUrl, useTrainingLabels, trainingOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomFormModel getCustomModel(String modelId) {
        return (CustomFormModel)this.getCustomModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomFormModel> getCustomModelWithResponse(String modelId, Context context) {
        return (Response)this.client.getCustomModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccountProperties getAccountProperties() {
        return (AccountProperties)this.getAccountPropertiesWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccountProperties> getAccountPropertiesWithResponse(Context context) {
        return (Response)this.client.getAccountPropertiesWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        return (Response)this.client.deleteModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomFormModelInfo> listCustomModels() {
        return new PagedIterable(this.client.listCustomModels(Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomFormModelInfo> listCustomModels(Context context) {
        return new PagedIterable(this.client.listCustomModels(context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target) {
        return this.beginCopyModel(modelId, target, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target, Duration pollInterval, Context context) {
        return this.client.beginCopyModel(modelId, target, pollInterval, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization getCopyAuthorization(String resourceId, String resourceRegion) {
        return (CopyAuthorization)this.getCopyAuthorizationWithResponse(resourceId, resourceRegion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> getCopyAuthorizationWithResponse(String resourceId, String resourceRegion, Context context) {
        return (Response)this.client.getCopyAuthorizationWithResponse(resourceId, resourceRegion, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds) {
        return this.beginCreateComposedModel(modelIds, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds, CreateComposedModelOptions createComposedModelOptions, Context context) {
        return this.client.beginCreateComposedModel(modelIds, createComposedModelOptions, context).getSyncPoller();
    }
}

