// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An object representing an extracted text line. */
@Fluent
public final class TextLine {
    /*
     * The text content of the line.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * Bounding box of an extracted line.
     */
    @JsonProperty(value = "boundingBox", required = true)
    private List<Float> boundingBox;

    /*
     * List of words in the text line.
     */
    @JsonProperty(value = "words", required = true)
    private List<TextWord> words;

    /*
     * Text appearance properties.
     */
    @JsonProperty(value = "appearance")
    private Appearance appearance;

    /**
     * Get the text property: The text content of the line.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The text content of the line.
     *
     * @param text the text value to set.
     * @return the TextLine object itself.
     */
    public TextLine setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the boundingBox property: Bounding box of an extracted line.
     *
     * @return the boundingBox value.
     */
    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    /**
     * Set the boundingBox property: Bounding box of an extracted line.
     *
     * @param boundingBox the boundingBox value to set.
     * @return the TextLine object itself.
     */
    public TextLine setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    /**
     * Get the words property: List of words in the text line.
     *
     * @return the words value.
     */
    public List<TextWord> getWords() {
        return this.words;
    }

    /**
     * Set the words property: List of words in the text line.
     *
     * @param words the words value to set.
     * @return the TextLine object itself.
     */
    public TextLine setWords(List<TextWord> words) {
        this.words = words;
        return this;
    }

    /**
     * Get the appearance property: Text appearance properties.
     *
     * @return the appearance value.
     */
    public Appearance getAppearance() {
        return this.appearance;
    }

    /**
     * Set the appearance property: Text appearance properties.
     *
     * @param appearance the appearance value to set.
     * @return the TextLine object itself.
     */
    public TextLine setAppearance(Appearance appearance) {
        this.appearance = appearance;
        return this;
    }
}
