// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for Locale. */
public final class Locale extends ExpandableStringEnum<Locale> {
    /** Static value en-AU for Locale. */
    public static final Locale EN_AU = fromString("en-AU");

    /** Static value en-CA for Locale. */
    public static final Locale EN_CA = fromString("en-CA");

    /** Static value en-GB for Locale. */
    public static final Locale EN_GB = fromString("en-GB");

    /** Static value en-IN for Locale. */
    public static final Locale EN_IN = fromString("en-IN");

    /** Static value en-US for Locale. */
    public static final Locale EN_US = fromString("en-US");

    /**
     * Creates or finds a Locale from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Locale.
     */
    @JsonCreator
    public static Locale fromString(String name) {
        return fromString(name, Locale.class);
    }

    /** @return known Locale values. */
    public static Collection<Locale> values() {
        return values(Locale.class);
    }
}
