// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeBusinessCardAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeIdDocumentAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeInvoiceAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeLayoutAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeReceiptAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeWithCustomModelResponse;
import com.azure.ai.formrecognizer.implementation.models.ComposeCustomModelsAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyCustomModelResponse;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.GenerateModelCopyAuthorizationResponse;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.implementation.models.TrainCustomModelAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the FormRecognizerClient type. */
public final class FormRecognizerClientImpl {
    /** The proxy service used to perform REST calls. */
    private final FormRecognizerClientService service;

    /**
     * Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     */
    private final String endpoint;

    /**
     * Gets Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Form Recognizer API version. */
    private final String apiVersion;

    /**
     * Gets Form Recognizer API version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Form Recognizer API version.
     */
    FormRecognizerClientImpl(String endpoint, String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                endpoint,
                apiVersion);
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Form Recognizer API version.
     */
    FormRecognizerClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Form Recognizer API version.
     */
    FormRecognizerClientImpl(
            HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service =
                RestProxy.create(FormRecognizerClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for FormRecognizerClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface FormRecognizerClientService {
        @Post("/custom/models")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<TrainCustomModelAsyncResponse> trainCustomModelAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @BodyParam("application/json") TrainRequest trainRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/custom/models/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Model>> getCustomModel(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @QueryParam("includeKeys") Boolean includeKeys,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/custom/models/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> deleteCustomModel(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("pages") String pages,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("pages") String pages,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/custom/models/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/custom/models/{modelId}/copy")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<CopyCustomModelResponse> copyCustomModel(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @BodyParam("application/json") CopyRequest copyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/custom/models/{modelId}/copyResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyOperationResult>> getCustomModelCopyResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("modelId") UUID modelId,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/custom/models/copyAuthorization")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorization(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/custom/models/compose")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @BodyParam("application/json") ComposeRequest composeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/prebuilt/businessCard/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/prebuilt/invoice/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("pages") String pages,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("pages") String pages,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/prebuilt/idDocument/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("includeTextDetails") Boolean includeTextDetails,
                @QueryParam("locale") Locale locale,
                @QueryParam("pages") String pages,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/prebuilt/receipt/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("pages") String pages,
                @QueryParam("language") Language language,
                @QueryParam("readingOrder") ReadingOrder readingOrder,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("pages") String pages,
                @QueryParam("language") Language language,
                @QueryParam("readingOrder") ReadingOrder readingOrder,
                @BodyParam("application/json") SourcePath fileStream,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/layout/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResult(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @PathParam("resultId") UUID resultId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/custom/models")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> listCustomModels(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("op") String op,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/custom/models")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> getCustomModels(
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @QueryParam("op") String op,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> listCustomModelsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HostParam("ApiVersion") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(TrainRequest trainRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.trainCustomModelAsync(
                                this.getEndpoint(), this.getApiVersion(), trainRequest, accept, context));
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(
            TrainRequest trainRequest, Context context) {
        final String accept = "application/json";
        return service.trainCustomModelAsync(this.getEndpoint(), this.getApiVersion(), trainRequest, accept, context);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> trainCustomModelAsyncAsync(TrainRequest trainRequest) {
        return trainCustomModelAsyncWithResponseAsync(trainRequest)
                .flatMap((TrainCustomModelAsyncResponse res) -> Mono.empty());
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> trainCustomModelAsyncAsync(TrainRequest trainRequest, Context context) {
        return trainCustomModelAsyncWithResponseAsync(trainRequest, context)
                .flatMap((TrainCustomModelAsyncResponse res) -> Mono.empty());
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void trainCustomModelAsync(TrainRequest trainRequest) {
        trainCustomModelAsyncAsync(trainRequest).block();
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     *
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TrainCustomModelAsyncResponse trainCustomModelAsyncWithResponse(TrainRequest trainRequest, Context context) {
        return trainCustomModelAsyncWithResponseAsync(trainRequest, context).block();
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Model>> getCustomModelWithResponseAsync(UUID modelId, Boolean includeKeys) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getCustomModel(
                                this.getEndpoint(), this.getApiVersion(), modelId, includeKeys, accept, context));
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Model>> getCustomModelWithResponseAsync(UUID modelId, Boolean includeKeys, Context context) {
        final String accept = "application/json";
        return service.getCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeKeys, accept, context);
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Model> getCustomModelAsync(UUID modelId, Boolean includeKeys) {
        return getCustomModelWithResponseAsync(modelId, includeKeys)
                .flatMap(
                        (Response<Model> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Model> getCustomModelAsync(UUID modelId, Boolean includeKeys, Context context) {
        return getCustomModelWithResponseAsync(modelId, includeKeys, context)
                .flatMap(
                        (Response<Model> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Model getCustomModel(UUID modelId, Boolean includeKeys) {
        return getCustomModelAsync(modelId, includeKeys).block();
    }

    /**
     * Get detailed information about a custom model.
     *
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Model> getCustomModelWithResponse(UUID modelId, Boolean includeKeys, Context context) {
        return getCustomModelWithResponseAsync(modelId, includeKeys, context).block();
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, accept, context));
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId, Context context) {
        final String accept = "application/json";
        return service.deleteCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, accept, context);
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteCustomModelAsync(UUID modelId) {
        return deleteCustomModelWithResponseAsync(modelId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteCustomModelAsync(UUID modelId, Context context) {
        return deleteCustomModelWithResponseAsync(modelId, context).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteCustomModel(UUID modelId) {
        deleteCustomModelAsync(modelId).block();
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     *
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteCustomModelWithResponse(UUID modelId, Context context) {
        return deleteCustomModelWithResponseAsync(modelId, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeWithCustomModel(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                modelId,
                                includeTextDetails,
                                pagesConverted,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeWithCustomModel(
                this.getEndpoint(),
                this.getApiVersion(),
                modelId,
                includeTextDetails,
                pagesConverted,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeWithCustomModelWithResponseAsync(
                        modelId, contentType, includeTextDetails, pages, fileStream, contentLength)
                .flatMap((AnalyzeWithCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeWithCustomModelWithResponseAsync(
                        modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context)
                .flatMap((AnalyzeWithCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeWithCustomModel(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeWithCustomModelAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeWithCustomModelResponse analyzeWithCustomModelWithResponse(
            UUID modelId,
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeWithCustomModelWithResponseAsync(
                        modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeWithCustomModel(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                modelId,
                                includeTextDetails,
                                pagesConverted,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeWithCustomModel(
                this.getEndpoint(),
                this.getApiVersion(),
                modelId,
                includeTextDetails,
                pagesConverted,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream)
                .flatMap((AnalyzeWithCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context)
                .flatMap((AnalyzeWithCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeWithCustomModel(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        analyzeWithCustomModelAsync(modelId, includeTextDetails, pages, fileStream).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     *
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeWithCustomModelResponse analyzeWithCustomModelWithResponse(
            UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).block();
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(UUID modelId, UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeFormResult(
                                this.getEndpoint(), this.getApiVersion(), modelId, resultId, accept, context));
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(
            UUID modelId, UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeFormResult(
                this.getEndpoint(), this.getApiVersion(), modelId, resultId, accept, context);
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeFormResultAsync(UUID modelId, UUID resultId) {
        return getAnalyzeFormResultWithResponseAsync(modelId, resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeFormResultAsync(UUID modelId, UUID resultId, Context context) {
        return getAnalyzeFormResultWithResponseAsync(modelId, resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeFormResult(UUID modelId, UUID resultId) {
        return getAnalyzeFormResultAsync(modelId, resultId).block();
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     *
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeFormResultWithResponse(
            UUID modelId, UUID resultId, Context context) {
        return getAnalyzeFormResultWithResponseAsync(modelId, resultId, context).block();
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyCustomModelResponse> copyCustomModelWithResponseAsync(UUID modelId, CopyRequest copyRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.copyCustomModel(
                                this.getEndpoint(), this.getApiVersion(), modelId, copyRequest, accept, context));
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyCustomModelResponse> copyCustomModelWithResponseAsync(
            UUID modelId, CopyRequest copyRequest, Context context) {
        final String accept = "application/json";
        return service.copyCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, copyRequest, accept, context);
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyCustomModelAsync(UUID modelId, CopyRequest copyRequest) {
        return copyCustomModelWithResponseAsync(modelId, copyRequest)
                .flatMap((CopyCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyCustomModelAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        return copyCustomModelWithResponseAsync(modelId, copyRequest, context)
                .flatMap((CopyCustomModelResponse res) -> Mono.empty());
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void copyCustomModel(UUID modelId, CopyRequest copyRequest) {
        copyCustomModelAsync(modelId, copyRequest).block();
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     *
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyCustomModelResponse copyCustomModelWithResponse(UUID modelId, CopyRequest copyRequest, Context context) {
        return copyCustomModelWithResponseAsync(modelId, copyRequest, context).block();
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCustomModelCopyResultWithResponseAsync(UUID modelId, UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getCustomModelCopyResult(
                                this.getEndpoint(), this.getApiVersion(), modelId, resultId, accept, context));
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCustomModelCopyResultWithResponseAsync(
            UUID modelId, UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getCustomModelCopyResult(
                this.getEndpoint(), this.getApiVersion(), modelId, resultId, accept, context);
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCustomModelCopyResultAsync(UUID modelId, UUID resultId) {
        return getCustomModelCopyResultWithResponseAsync(modelId, resultId)
                .flatMap(
                        (Response<CopyOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCustomModelCopyResultAsync(UUID modelId, UUID resultId, Context context) {
        return getCustomModelCopyResultWithResponseAsync(modelId, resultId, context)
                .flatMap(
                        (Response<CopyOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyOperationResult getCustomModelCopyResult(UUID modelId, UUID resultId) {
        return getCustomModelCopyResultAsync(modelId, resultId).block();
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     *
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyOperationResult> getCustomModelCopyResultWithResponse(
            UUID modelId, UUID resultId, Context context) {
        return getCustomModelCopyResultWithResponseAsync(modelId, resultId, context).block();
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorizationWithResponseAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.generateModelCopyAuthorization(
                                this.getEndpoint(), this.getApiVersion(), accept, context));
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorizationWithResponseAsync(
            Context context) {
        final String accept = "application/json";
        return service.generateModelCopyAuthorization(this.getEndpoint(), this.getApiVersion(), accept, context);
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> generateModelCopyAuthorizationAsync() {
        return generateModelCopyAuthorizationWithResponseAsync()
                .flatMap(
                        (GenerateModelCopyAuthorizationResponse res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> generateModelCopyAuthorizationAsync(Context context) {
        return generateModelCopyAuthorizationWithResponseAsync(context)
                .flatMap(
                        (GenerateModelCopyAuthorizationResponse res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyAuthorizationResult generateModelCopyAuthorization() {
        return generateModelCopyAuthorizationAsync().block();
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GenerateModelCopyAuthorizationResponse generateModelCopyAuthorizationWithResponse(Context context) {
        return generateModelCopyAuthorizationWithResponseAsync(context).block();
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsyncWithResponseAsync(
            ComposeRequest composeRequest) {
        final String accept = "application/json, text/json";
        return FluxUtil.withContext(
                context ->
                        service.composeCustomModelsAsync(
                                this.getEndpoint(), this.getApiVersion(), composeRequest, accept, context));
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsyncWithResponseAsync(
            ComposeRequest composeRequest, Context context) {
        final String accept = "application/json, text/json";
        return service.composeCustomModelsAsync(
                this.getEndpoint(), this.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> composeCustomModelsAsyncAsync(ComposeRequest composeRequest) {
        return composeCustomModelsAsyncWithResponseAsync(composeRequest)
                .flatMap((ComposeCustomModelsAsyncResponse res) -> Mono.empty());
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> composeCustomModelsAsyncAsync(ComposeRequest composeRequest, Context context) {
        return composeCustomModelsAsyncWithResponseAsync(composeRequest, context)
                .flatMap((ComposeCustomModelsAsyncResponse res) -> Mono.empty());
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void composeCustomModelsAsync(ComposeRequest composeRequest) {
        composeCustomModelsAsyncAsync(composeRequest).block();
    }

    /**
     * Compose request would include list of models ids. It would validate what all models either trained with labels
     * model or composed model. It would validate limit of models put together.
     *
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ComposeCustomModelsAsyncResponse composeCustomModelsAsyncWithResponse(
            ComposeRequest composeRequest, Context context) {
        return composeCustomModelsAsyncWithResponseAsync(composeRequest, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeBusinessCardAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeBusinessCardAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeBusinessCardAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength)
                .flatMap((AnalyzeBusinessCardAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeBusinessCardAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .flatMap((AnalyzeBusinessCardAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeBusinessCardAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeBusinessCardAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength)
                .block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeBusinessCardAsyncResponse analyzeBusinessCardAsyncWithResponse(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeBusinessCardAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeBusinessCardAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeBusinessCardAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream)
                .flatMap((AnalyzeBusinessCardAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
                .flatMap((AnalyzeBusinessCardAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeBusinessCardAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        analyzeBusinessCardAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeBusinessCardAsyncResponse analyzeBusinessCardAsyncWithResponse(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
                .block();
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeBusinessCardResult(
                                this.getEndpoint(), this.getApiVersion(), resultId, accept, context));
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(
            UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeBusinessCardResult(
                this.getEndpoint(), this.getApiVersion(), resultId, accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId, Context context) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeBusinessCardResult(UUID resultId) {
        return getAnalyzeBusinessCardResultAsync(resultId).block();
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeBusinessCardResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeInvoiceAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeInvoiceAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeInvoiceAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength)
                .flatMap((AnalyzeInvoiceAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeInvoiceAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .flatMap((AnalyzeInvoiceAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeInvoiceAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeInvoiceAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeInvoiceAsyncResponse analyzeInvoiceAsyncWithResponse(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeInvoiceAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeInvoiceAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeInvoiceAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream)
                .flatMap((AnalyzeInvoiceAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
                .flatMap((AnalyzeInvoiceAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeInvoiceAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        analyzeInvoiceAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeInvoiceAsyncResponse analyzeInvoiceAsyncWithResponse(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeInvoiceResult(
                                this.getEndpoint(), this.getApiVersion(), resultId, accept, context));
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(
            UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeInvoiceResult(this.getEndpoint(), this.getApiVersion(), resultId, accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId, Context context) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeInvoiceResult(UUID resultId) {
        return getAnalyzeInvoiceResultAsync(resultId).block();
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeInvoiceResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeIdDocumentAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                pagesConverted,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeIdDocumentAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                pagesConverted,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeIdDocumentAsyncWithResponseAsync(
                        contentType, includeTextDetails, pages, fileStream, contentLength)
                .flatMap((AnalyzeIdDocumentAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeIdDocumentAsyncWithResponseAsync(
                        contentType, includeTextDetails, pages, fileStream, contentLength, context)
                .flatMap((AnalyzeIdDocumentAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeIdDocumentAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeIdDocumentAsyncAsync(contentType, includeTextDetails, pages, fileStream, contentLength).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeIdDocumentAsyncResponse analyzeIdDocumentAsyncWithResponse(
            ContentType contentType,
            Boolean includeTextDetails,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeIdDocumentAsyncWithResponseAsync(
                        contentType, includeTextDetails, pages, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(
            Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeIdDocumentAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                pagesConverted,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(
            Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeIdDocumentAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                pagesConverted,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(
            Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream)
                .flatMap((AnalyzeIdDocumentAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(
            Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream, context)
                .flatMap((AnalyzeIdDocumentAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        analyzeIdDocumentAsyncAsync(includeTextDetails, pages, fileStream).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeIdDocumentAsyncResponse analyzeIdDocumentAsyncWithResponse(
            Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeIdDocumentResult(
                                this.getEndpoint(), this.getApiVersion(), resultId, accept, context));
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(
            UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeIdDocumentResult(this.getEndpoint(), this.getApiVersion(), resultId, accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId, Context context) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeIdDocumentResult(UUID resultId) {
        return getAnalyzeIdDocumentResultAsync(resultId).block();
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeIdDocumentResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeReceiptAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeReceiptAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeReceiptAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength)
                .flatMap((AnalyzeReceiptAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeReceiptAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .flatMap((AnalyzeReceiptAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeReceiptAsync(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeReceiptAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeReceiptAsyncResponse analyzeReceiptAsyncWithResponse(
            ContentType contentType,
            Boolean includeTextDetails,
            Locale locale,
            List<String> pages,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeReceiptAsyncWithResponseAsync(
                        contentType, includeTextDetails, locale, pages, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeReceiptAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                includeTextDetails,
                                locale,
                                pagesConverted,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeReceiptAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                includeTextDetails,
                locale,
                pagesConverted,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream)
                .flatMap((AnalyzeReceiptAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
                .flatMap((AnalyzeReceiptAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeReceiptAsync(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        analyzeReceiptAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     *
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     *     en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeReceiptAsyncResponse analyzeReceiptAsyncWithResponse(
            Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeReceiptResult(
                                this.getEndpoint(), this.getApiVersion(), resultId, accept, context));
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(
            UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeReceiptResult(this.getEndpoint(), this.getApiVersion(), resultId, accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId, Context context) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeReceiptResult(UUID resultId) {
        return getAnalyzeReceiptResultAsync(resultId).block();
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeReceiptResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeLayoutAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                pagesConverted,
                                language,
                                readingOrder,
                                contentType,
                                fileStream,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeLayoutAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                pagesConverted,
                language,
                readingOrder,
                contentType,
                fileStream,
                contentLength,
                accept,
                context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        return analyzeLayoutAsyncWithResponseAsync(
                        contentType, pages, language, readingOrder, fileStream, contentLength)
                .flatMap((AnalyzeLayoutAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeLayoutAsyncWithResponseAsync(
                        contentType, pages, language, readingOrder, fileStream, contentLength, context)
                .flatMap((AnalyzeLayoutAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeLayoutAsync(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength) {
        analyzeLayoutAsyncAsync(contentType, pages, language, readingOrder, fileStream, contentLength).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The contentLength parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeLayoutAsyncResponse analyzeLayoutAsyncWithResponse(
            ContentType contentType,
            List<String> pages,
            Language language,
            ReadingOrder readingOrder,
            Flux<ByteBuffer> fileStream,
            Long contentLength,
            Context context) {
        return analyzeLayoutAsyncWithResponseAsync(
                        contentType, pages, language, readingOrder, fileStream, contentLength, context)
                .block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(
                context ->
                        service.analyzeLayoutAsync(
                                this.getEndpoint(),
                                this.getApiVersion(),
                                pagesConverted,
                                language,
                                readingOrder,
                                fileStream,
                                accept,
                                context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return service.analyzeLayoutAsync(
                this.getEndpoint(),
                this.getApiVersion(),
                pagesConverted,
                language,
                readingOrder,
                fileStream,
                accept,
                context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream)
                .flatMap((AnalyzeLayoutAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream, context)
                .flatMap((AnalyzeLayoutAsyncResponse res) -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeLayoutAsync(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        analyzeLayoutAsyncAsync(pages, language, readingOrder, fileStream).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     *
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     *     get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     *     (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’),
     *     Crimean Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian
     *     (‘et’), Fijian (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’),
     *     German (‘de’), Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw
     *     (‘mww’), Hungarian (‘hu’), Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian
     *     (‘it’), Japanese (‘ja’), Javanese (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’),
     *     Kashubian (‘csb’), Khasi (‘kha’), Korean (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’),
     *     Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’), Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish
     *     (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese
     *     (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’),
     *     Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük
     *     (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are
     *     supported (print – seventy-three languages and handwritten – English only). Layout supports auto language
     *     identification and multi language documents, so only provide a language code if you would like to force the
     *     documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     *     basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeLayoutAsyncResponse analyzeLayoutAsyncWithResponse(
            List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeLayoutResult(
                                this.getEndpoint(), this.getApiVersion(), resultId, accept, context));
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(
            UUID resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeLayoutResult(this.getEndpoint(), this.getApiVersion(), resultId, accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId, Context context) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId, context)
                .flatMap(
                        (Response<AnalyzeOperationResult> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeLayoutResult(UUID resultId) {
        return getAnalyzeLayoutResultAsync(resultId).block();
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     *
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeLayoutResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync() {
        final String op = "full";
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listCustomModels(this.getEndpoint(), this.getApiVersion(), op, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getModelList(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync(Context context) {
        final String op = "full";
        final String accept = "application/json";
        return service.listCustomModels(this.getEndpoint(), this.getApiVersion(), op, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getModelList(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listCustomModelsAsync() {
        return new PagedFlux<>(
                () -> listCustomModelsSinglePageAsync(), nextLink -> listCustomModelsNextSinglePageAsync(nextLink));
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listCustomModelsAsync(Context context) {
        return new PagedFlux<>(
                () -> listCustomModelsSinglePageAsync(context),
                nextLink -> listCustomModelsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> listCustomModels() {
        return new PagedIterable<>(listCustomModelsAsync());
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> listCustomModels(Context context) {
        return new PagedIterable<>(listCustomModelsAsync(context));
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Models>> getCustomModelsWithResponseAsync() {
        final String op = "summary";
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getCustomModels(this.getEndpoint(), this.getApiVersion(), op, accept, context));
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Models>> getCustomModelsWithResponseAsync(Context context) {
        final String op = "summary";
        final String accept = "application/json";
        return service.getCustomModels(this.getEndpoint(), this.getApiVersion(), op, accept, context);
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Models> getCustomModelsAsync() {
        return getCustomModelsWithResponseAsync()
                .flatMap(
                        (Response<Models> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Models> getCustomModelsAsync(Context context) {
        return getCustomModelsWithResponseAsync(context)
                .flatMap(
                        (Response<Models> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get information about all custom models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Models getCustomModels() {
        return getCustomModelsAsync().block();
    }

    /**
     * Get information about all custom models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Models> getCustomModelsWithResponse(Context context) {
        return getCustomModelsWithResponseAsync(context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listCustomModelsNext(
                                        nextLink, this.getEndpoint(), this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getModelList(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listCustomModelsNext(nextLink, this.getEndpoint(), this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getModelList(),
                                        res.getValue().getNextLink(),
                                        null));
    }
}
