// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A word object consisting of a contiguous sequence of characters. For non-space delimited languages, such as Chinese,
 * Japanese, and Korean, each character is represented as its own word.
 */
@Fluent
public final class DocumentWord {
    /*
     * Text content of the word.
     */
    @JsonProperty(value = "content", required = true)
    private String content;

    /*
     * Bounding polygon of the word.
     */
    @JsonProperty(value = "polygon")
    private List<Float> polygon;

    /*
     * Location of the word in the reading order concatenated content.
     */
    @JsonProperty(value = "span", required = true)
    private DocumentSpan span;

    /*
     * Confidence of correctly extracting the word.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /** Creates an instance of DocumentWord class. */
    public DocumentWord() {}

    /**
     * Get the content property: Text content of the word.
     *
     * @return the content value.
     */
    public String getContent() {
        return this.content;
    }

    /**
     * Set the content property: Text content of the word.
     *
     * @param content the content value to set.
     * @return the DocumentWord object itself.
     */
    public DocumentWord setContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the polygon property: Bounding polygon of the word.
     *
     * @return the polygon value.
     */
    public List<Float> getPolygon() {
        return this.polygon;
    }

    /**
     * Set the polygon property: Bounding polygon of the word.
     *
     * @param polygon the polygon value to set.
     * @return the DocumentWord object itself.
     */
    public DocumentWord setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    /**
     * Get the span property: Location of the word in the reading order concatenated content.
     *
     * @return the span value.
     */
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Set the span property: Location of the word in the reading order concatenated content.
     *
     * @param span the span value to set.
     * @return the DocumentWord object itself.
     */
    public DocumentWord setSpan(DocumentSpan span) {
        this.span = span;
        return this;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the word.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence of correctly extracting the word.
     *
     * @param confidence the confidence value to set.
     * @return the DocumentWord object itself.
     */
    public DocumentWord setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }
}
